/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.conversion.FormatConverterManager;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.authentication.InvalidSessionException;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.html.HTMLSanitizer;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang.StringUtils;
import org.hsqldb.lib.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DownloadServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            Session session = ServletUtil.validateSession(request);
            if (request.getParameter("pluginId") != null) {
                ServletUtil.downloadPluginResource(request, response, session.getSid(), request.getParameter("pluginId"), request.getParameter("resourcePath"), request.getParameter("fileName"));
            } else {
                this.downloadDocument(request, response, session);
            }
        }
        catch (PersistenceException | InvalidSessionException | ServletException | IOException e) {
            if (e.getClass().getName().contains("ClientAbortException")) {
                log.debug(e.getMessage(), e);
            }
            log.error(e.getMessage(), e);
            ServletUtil.sendError(response, e.getMessage());
        }
    }

    private void downloadDocument(HttpServletRequest request, HttpServletResponse response, Session session) throws IOException, ServletException, PersistenceException {
        DocumentDAO docDao = Context.get(DocumentDAO.class);
        VersionDAO versDao = Context.get(VersionDAO.class);
        String downloadText = request.getParameter("downloadText");
        Long docId = this.getDocId(request);
        Long versionId = this.getVersionId(request);
        String ver = request.getParameter("version");
        String fileVersion = request.getParameter("fileVersion");
        String suffix = request.getParameter("suffix");
        Document document = null;
        if (docId != null) {
            document = (Document)docDao.findById(docId);
            this.checkDownloadPermission(session, document);
            suffix = this.convertToPdf(session, downloadText, fileVersion, suffix, document);
            document = this.getReferencedDocument(docDao, document);
        }
        Version version = null;
        if (versionId != null) {
            version = (Version)versDao.findById(versionId);
            if (document == null && version != null) {
                document = docDao.findDocument(version.getDocId());
                this.checkDownloadPermission(session, document);
            }
        }
        if (version == null && document != null && StringUtils.isNotEmpty(ver)) {
            version = versDao.findByVersion(document.getId(), ver);
        }
        if (version == null && document != null && StringUtils.isNotEmpty(fileVersion)) {
            version = versDao.findByFileVersion(document.getId(), fileVersion);
        }
        this.checkPasswordProtection(session, document);
        DownloadServlet.processSafeHtml(suffix, version, document);
        String filename = this.getFilename(document, version);
        ServletUtil.setContentDisposition(request, response, filename);
        if (StringUtils.isEmpty(fileVersion)) {
            if (version != null) {
                fileVersion = version.getFileVersion();
            } else if (document != null) {
                fileVersion = document.getFileVersion();
            }
        }
        if (StringUtils.isEmpty(suffix)) {
            suffix = "";
        }
        this.download(request, response, session, downloadText, docId, fileVersion, filename, suffix, document);
    }

    private Document getReferencedDocument(DocumentDAO docDao, Document document) throws PersistenceException {
        if (document.getDocRef() != null) {
            document = (Document)docDao.findById(document.getDocRef());
        }
        return document;
    }

    private String getFilename(Document document, Version version) {
        String filename = "";
        if (version != null) {
            filename = version.getFileName();
        } else if (document != null) {
            filename = document.getFileName();
        }
        return filename;
    }

    private Long getVersionId(HttpServletRequest request) {
        Long versionId = null;
        try {
            if (request.getParameter("versionId") != null) {
                versionId = Long.parseLong(request.getParameter("versionId"));
            }
        }
        catch (NumberFormatException e) {
            log.warn("Invalid version ID: {}", (Object)versionId);
        }
        return versionId;
    }

    private Long getDocId(HttpServletRequest request) {
        Long docId = null;
        try {
            docId = Long.parseLong(request.getParameter("docId"));
        }
        catch (NumberFormatException e) {
            log.error("Invalid document ID: {}", (Object)docId);
        }
        return docId;
    }

    private void checkPasswordProtection(Session session, Document doc) throws IOException {
        if (doc != null && doc.isPasswordProtected() && !session.getUnprotectedDocs().containsKey(doc.getId())) {
            throw new IOException("The document is protected by a password");
        }
    }

    private String convertToPdf(Session session, String downloadText, String fileVersion, String suffix, Document doc) {
        if (doc.getDocRef() != null && StringUtil.isEmpty((String)downloadText) && doc.getDocRefType() != null && doc.getDocRefType().contains("pdf")) {
            FormatConverterManager manager = Context.get(FormatConverterManager.class);
            try {
                manager.convertToPdf(doc, fileVersion, session.getSid());
            }
            catch (Exception e) {
                log.error("Cannot convert to PDF the document {}", (Object)doc);
            }
            suffix = "conversion.pdf";
        }
        return suffix;
    }

    private void checkDownloadPermission(Session session, Document doc) throws PersistenceException, IOException {
        DocumentDAO documentDao = Context.get(DocumentDAO.class);
        if (!documentDao.isDownloadAllowed(doc.getId(), session.getUserId())) {
            throw new IOException("You don't have the DOWNLOAD permission");
        }
    }

    private void download(HttpServletRequest request, HttpServletResponse response, Session session, String downloadText, Long docId, String fileVersion, String filename, String suffix, Document doc) throws IOException, PersistenceException, ServletException {
        if (doc != null) {
            if ("true".equals(downloadText)) {
                ServletUtil.downloadDocumentText(request, response, doc.getId(), session.getUser());
            } else {
                ServletUtil.downloadDocument(request, response, session.getSid(), doc.getId(), fileVersion, filename, suffix, session.getUser());
            }
        } else {
            throw new FileNotFoundException("Cannot find document " + String.valueOf(docId));
        }
    }

    static void processSafeHtml(String suffix, Version version, Document doc) throws IOException {
        if ("safe.html".equals(suffix)) {
            Store store = Context.get(Store.class);
            if (doc != null) {
                String safeResource = store.getResourceName(doc, version == null ? doc.getFileVersion() : version.getFileVersion(), suffix);
                if (!store.exists(doc.getId(), safeResource)) {
                    String unsafeResource = store.getResourceName(doc, version == null ? doc.getFileVersion() : version.getFileVersion(), null);
                    String unsafe = store.getString(doc.getId(), unsafeResource);
                    String safe = HTMLSanitizer.sanitize(unsafe);
                    store.store(new ByteArrayInputStream(safe.getBytes(StandardCharsets.UTF_8)), doc.getId(), safeResource);
                }
            }
        }
    }
}

