/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.communication.EMail;
import com.logicaldoc.core.communication.EMailAttachment;
import com.logicaldoc.core.communication.MailUtil;
import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.store.Store;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.mail.MessagingException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.bouncycastle.cms.CMSException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadAttachmentServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DownloadAttachmentServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            Session session = ServletUtil.validateSession(request);
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            FolderDAO folderDao = Context.get(FolderDAO.class);
            long docId = Long.parseLong(request.getParameter("docId"));
            String fileVersion = request.getParameter("fileVersion");
            String filename = request.getParameter("attachmentFileName");
            Document doc = (Document)docDao.findById(docId);
            if (session.getUser() != null && !folderDao.isPermissionAllowed(Permission.DOWNLOAD, doc.getFolder().getId(), session.getUserId())) {
                throw new IOException("You don't have the DOWNLOAD permission");
            }
            if (doc.getDocRef() != null) {
                doc = (Document)docDao.findById(doc.getDocRef());
            }
            if (doc != null && doc.isPasswordProtected() && !session.getUnprotectedDocs().containsKey(doc.getId())) {
                throw new IOException("The document is protected by a password");
            }
            this.download(request, response, docId, fileVersion, filename, doc);
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            ServletUtil.sendError(response, e.getMessage());
        }
    }

    private void download(HttpServletRequest request, HttpServletResponse response, long docId, String fileVersion, String filename, Document doc) throws MessagingException, IOException, CMSException {
        Store store = Context.get(Store.class);
        String resource = store.getResourceName(docId, fileVersion, null);
        Throwable throwable = null;
        Object var11_11 = null;
        try (InputStream is = store.getStream(docId, resource);){
            EMail email = null;
            email = doc != null && doc.getFileName().toLowerCase().endsWith(".eml") ? MailUtil.messageToMail(is, true) : MailUtil.msgToMail(is, true);
            EMailAttachment attachment = null;
            if (email.getAttachments().size() > 0) {
                for (EMailAttachment att : email.getAttachments().values()) {
                    if (!filename.equals(att.getFileName())) continue;
                    attachment = att;
                    break;
                }
            }
            if (attachment == null || attachment.getData() == null) {
                throw new IOException("Attachment not found");
            }
            File tmp = null;
            try {
                tmp = FileUtil.createTempFile("attdown", null);
                FileUtils.writeByteArrayToFile(tmp, attachment.getData());
                ServletUtil.downloadFile(request, response, tmp, filename);
            }
            finally {
                FileUtil.delete(tmp);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

