/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.security.Permission;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DocumentResourceUpload
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(DocumentResourceUpload.class);
    public static final String DOC_ID = "docId";
    public static final String SUFFIX = "suffix";
    public static final String VERSION_ID = "versionId";
    public static final String VERSION_DOC = "versionDoc";

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            response.setContentType("text/html");
            PrintWriter out = response.getWriter();
            out.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
            out.println("<HTML>");
            out.println("  <HEAD><TITLE>Upload Document Resource Servlet</TITLE></HEAD>");
            out.println("  <BODY>");
            out.print(" This servlet doesn't support GET method. Use POST instead. ");
            out.println("  </BODY>");
            out.println("</HTML>");
            out.flush();
            out.close();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            Session session = ServletUtil.validateSession(request);
            UserDAO udao = Context.get(UserDAO.class);
            User user = udao.findByUsername(session.getUsername());
            if (user == null) {
                return;
            }
            long docId = Long.parseLong(request.getParameter(DOC_ID));
            String suffix = request.getParameter(SUFFIX);
            String fileVersion = request.getParameter(VERSION_ID);
            String docVersion = request.getParameter(VERSION_DOC);
            log.debug("Start Upload resource for document {}", (Object)docId);
            FolderDAO fdao = Context.get(FolderDAO.class);
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            Document doc = (Document)docDao.findById(docId);
            Folder folder = doc.getFolder();
            if (fdao.isPermissionAllowed(Permission.SIGN, folder.getId(), user.getId())) {
                ServletUtil.uploadDocumentResource(request, docId, suffix, fileVersion, docVersion);
                if (suffix.startsWith("sign")) {
                    docDao.initialize(doc);
                    doc.setSigned(1);
                    docDao.store(doc);
                    VersionDAO vdao = Context.get(VersionDAO.class);
                    Version version = null;
                    version = StringUtils.isNotEmpty(docVersion) ? vdao.findByVersion(doc.getId(), docVersion) : vdao.findByVersion(doc.getId(), doc.getVersion());
                    vdao.initialize(version);
                    version.setSigned(1);
                    vdao.store(version);
                }
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
    }
}

