/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.folder.Folder;
import com.logicaldoc.core.folder.FolderDAO;
import com.logicaldoc.core.security.user.User;
import com.logicaldoc.core.security.user.UserDAO;
import com.logicaldoc.util.spring.Context;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DisplayServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String USER = "user";
    public static final String DOC_ID = "docId";
    public static final String FOLDER_ID = "folderId";
    public static final String FOLDER_PATH = "folderPath";
    private static final Logger log = LoggerFactory.getLogger(DisplayServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        String docId = request.getParameter(DOC_ID);
        String folderId = request.getParameter(FOLDER_ID);
        String folderPath = request.getParameter(FOLDER_PATH);
        String username = request.getParameter(USER);
        try {
            String redirectUrl = request.getContextPath() + "/frontend.jsp?";
            if (StringUtils.isNotEmpty(docId)) {
                redirectUrl = redirectUrl + "docId=" + docId;
            } else if (StringUtils.isNotEmpty(folderId)) {
                redirectUrl = redirectUrl + "folderId=" + folderId;
            } else if (StringUtils.isNotEmpty(folderPath)) {
                UserDAO uDao = Context.get(UserDAO.class);
                User user = uDao.findByUsername(username);
                FolderDAO fDao = Context.get(FolderDAO.class);
                Folder folder = fDao.findByPathExtended(folderPath, user.getTenantId());
                redirectUrl = redirectUrl + "folderId=" + folder.getId();
            }
            response.sendRedirect(redirectUrl);
        }
        catch (PersistenceException | IOException e) {
            log.error(e.getMessage(), e);
            try {
                response.sendError(500, e.getMessage());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

