/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.document.Document;
import com.logicaldoc.core.document.DocumentDAO;
import com.logicaldoc.core.document.Version;
import com.logicaldoc.core.document.VersionDAO;
import com.logicaldoc.core.security.Session;
import com.logicaldoc.util.io.ResourceUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertPdf
extends HttpServlet {
    private static final String VERSION = "version";
    private static final String DOCUMENT_ID = "docId";
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ConvertPdf.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            Session session = ServletUtil.validateSession(request);
            DocumentDAO docDao = Context.get(DocumentDAO.class);
            VersionDAO versionDao = Context.get(VersionDAO.class);
            long docId = Long.parseLong(request.getParameter(DOCUMENT_ID));
            Document document = (Document)docDao.findById(docId);
            if (document.getDocRef() != null) {
                document = (Document)docDao.findById(document.getDocRef());
            }
            if (!document.getFileName().toLowerCase().endsWith(".pdf")) {
                throw new IOException("Unsupported format");
            }
            String ver = document.getVersion();
            if (StringUtils.isNotEmpty(request.getParameter(VERSION))) {
                ver = request.getParameter(VERSION);
            }
            Version version = versionDao.findByVersion(docId, ver);
            String suffix = null;
            ServletUtil.downloadDocument(request, response, null, document.getId(), version.getFileVersion(), null, suffix, session.getUser());
            return;
        }
        catch (Exception r) {
            log.error(r.getMessage(), r);
            int letter = 0;
            try {
                Throwable versionDao = null;
                Object var6_12 = null;
                try {
                    InputStream is = ResourceUtil.getInputStream("pdf/notavailable.pdf");
                    try {
                        try (ServletOutputStream os = response.getOutputStream();){
                            ServletUtil.setContentDisposition(request, response, "notavailable.pdf");
                            while ((letter = is.read()) != -1) {
                                os.write(letter);
                            }
                        }
                        if (is == null) return;
                    }
                    catch (Throwable throwable) {
                        if (versionDao == null) {
                            versionDao = throwable;
                        } else if (versionDao != throwable) {
                            versionDao.addSuppressed(throwable);
                        }
                        if (is == null) throw versionDao;
                        is.close();
                        throw versionDao;
                    }
                    is.close();
                    return;
                }
                catch (Throwable throwable) {
                    if (versionDao == null) {
                        versionDao = throwable;
                        throw versionDao;
                    } else {
                        if (versionDao == throwable) throw versionDao;
                        versionDao.addSuppressed(throwable);
                    }
                    throw versionDao;
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) {
        try {
            this.doGet(request, response);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

