/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.PersistenceException;
import com.logicaldoc.core.sequence.SequenceDAO;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.util.LocaleUtil;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.Color;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.HorizontalAlignment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChartServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ChartServlet.class);

    protected String sequencePrefix() {
        return "prefix";
    }

    protected String messageTitle() {
        return "key";
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block8: {
            File chartFile = null;
            try {
                try {
                    ServletUtil.validateSession(request);
                    int width = 1200;
                    if (request.getParameter("width") != null) {
                        width = Integer.parseInt(request.getParameter("width"));
                    }
                    int height = 450;
                    if (request.getParameter("height") != null) {
                        height = Integer.parseInt(request.getParameter("height"));
                    }
                    Locale locale = Locale.ENGLISH;
                    if (request.getParameter("locale") != null) {
                        locale = LocaleUtil.toLocale(request.getParameter("locale"));
                    }
                    chartFile = FileUtil.createTempFile("chart", ".png");
                    this.drawChart(chartFile, width, height, locale, this.getObjectId(request), this.getTenantId(request));
                    ServletUtil.downloadFile(request, response, chartFile, "chart.png");
                }
                catch (Exception e) {
                    log.error(e.getMessage(), e);
                    FileUtil.delete(chartFile);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                FileUtil.delete(chartFile);
                throw throwable;
            }
            FileUtil.delete(chartFile);
        }
    }

    protected long getObjectId(HttpServletRequest request) throws IOException, PersistenceException {
        return Long.parseLong(StringUtils.defaultString((String)request.getParameter("objectId"), (String)"0"));
    }

    protected long getTenantId(HttpServletRequest request) throws IOException, PersistenceException {
        return Long.parseLong(StringUtils.defaultString((String)request.getParameter("tenantId"), (String)String.valueOf(-1L)));
    }

    protected void drawChart(File chartFile, int width, int height, Locale locale, long objectId, long tenantId) throws IOException {
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        SequenceDAO dao = Context.get(SequenceDAO.class);
        SimpleDateFormat dfName = new SimpleDateFormat("MMM yyyy", locale);
        SimpleDateFormat dfNumber = new SimpleDateFormat("yyyyMM");
        int i = 0;
        while (i < 36) {
            Calendar cal = Calendar.getInstance();
            cal.add(2, -i);
            String month = dfNumber.format(cal.getTime());
            String monthName = dfName.format(cal.getTime());
            dataset.addValue((double)dao.getCurrentValue(this.sequencePrefix() + "-" + month, objectId, tenantId), (Comparable)((Object)I18N.message(this.messageTitle(), locale)), (Comparable)((Object)monthName));
            ++i;
        }
        JFreeChart chart = ChartFactory.createBarChart((String)"", null, null, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
        CategoryPlot catPlot = chart.getCategoryPlot();
        catPlot.getRangeAxis().setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        BarRenderer r = (BarRenderer)catPlot.getRenderer();
        r.setSeriesPaint(0, (Paint)Color.BLUE);
        chart.getTitle().setHorizontalAlignment(HorizontalAlignment.LEFT);
        chart.getTitle().setPaint((Paint)Color.BLUE);
        CategoryAxis domainAxis = catPlot.getDomainAxis();
        domainAxis.setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        ChartUtilities.saveChartAsPNG((File)chartFile, (JFreeChart)chart, (int)width, (int)height);
    }
}

