/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.web;

import com.logicaldoc.core.util.UserUtil;
import com.logicaldoc.util.MimeType;
import com.logicaldoc.web.util.ServletUtil;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvatarServlet
extends HttpServlet {
    public static final String USER_ID = "userId";
    private static final long serialVersionUID = -6956612970433309888L;
    private static final String DATA_PREFIX = "data:image/";
    private static final Logger log = LoggerFactory.getLogger(AvatarServlet.class);

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            String id = request.getParameter(USER_ID);
            String content = UserUtil.getAvatarImage(id);
            String fileName = "avatar-" + id + "." + this.getExtension(content);
            response.setContentType(MimeType.getByFilename(fileName));
            ServletUtil.setContentDisposition(request, response, fileName);
            this.saveImage(content, (OutputStream)response.getOutputStream());
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            ServletUtil.sendError(response, e.getMessage());
        }
    }

    private String getExtension(String content) {
        String extension = "png";
        if (content.startsWith(DATA_PREFIX) && (extension = content.substring(content.indexOf(47) + 1, content.indexOf(59) - 1)).contains("+")) {
            extension = extension.substring(0, extension.indexOf(43));
        }
        return extension;
    }

    private void saveImage(String content, OutputStream out) throws IOException {
        if (content.startsWith(DATA_PREFIX)) {
            content = content.substring(content.indexOf(44) + 1);
        }
        Base64.Decoder decoder = Base64.getDecoder();
        byte[] imageByte = decoder.decode(content);
        Throwable throwable = null;
        Object var6_7 = null;
        try (ByteArrayInputStream bis = new ByteArrayInputStream(imageByte);){
            IOUtils.write(imageByte, out);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

