/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.spring;

import jakarta.persistence.Entity;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.orm.hibernate5.LocalSessionFactoryBean;

public class LocalSessionFactory
extends LocalSessionFactoryBean {
    private static final Logger log = LoggerFactory.getLogger(LocalSessionFactory.class);

    public void afterPropertiesSet() throws IOException {
        ArrayList annotatedClasses = new ArrayList();
        ClassPathScanningCandidateComponentProvider scanner = new ClassPathScanningCandidateComponentProvider(false);
        scanner.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(Entity.class));
        for (BeanDefinition bd : scanner.findCandidateComponents("com.logicaldoc")) {
            if (bd.isAbstract()) continue;
            try {
                annotatedClasses.add(Class.forName(bd.getBeanClassName()));
            }
            catch (Exception e) {
                log.error(e.getMessage(), e);
            }
        }
        this.setAnnotatedClasses(annotatedClasses.toArray(new Class[0]));
        super.afterPropertiesSet();
    }
}

