/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.spring;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.event.SystemEventListener;
import com.logicaldoc.util.event.SystemEventStatus;
import com.logicaldoc.util.spring.PluginContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.CacheManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.ContextStartedEvent;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@ComponentScan(basePackages={"com.logicaldoc"}, useDefaultFilters=false, includeFilters={@ComponentScan.Filter(type=FilterType.ANNOTATION, value={PluginContext.class})})
@ImportResource(value={"classpath:context.xml"})
@Component(value="context")
public class Context
implements ApplicationContextAware,
ApplicationListener<ApplicationEvent> {
    private static final Logger log = LoggerFactory.getLogger(Context.class);
    private static Map<SystemEventStatus, LinkedList<SystemEventListener>> systemEvents = new EnumMap<SystemEventStatus, LinkedList<SystemEventListener>>(SystemEventStatus.class);
    private ApplicationContext applicationContext;
    private static Context instance;

    private Context() {
    }

    public static Context get() {
        return instance;
    }

    public static <R> R get(Class<R> requiredType) {
        return Context.get().getBean(requiredType);
    }

    public static Object get(String id) {
        return Context.get().getBean(id);
    }

    public boolean isInitialized() {
        return this.applicationContext != null;
    }

    public ContextProperties getProperties() {
        return this.getBean(ContextProperties.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        Context.setInstance((Context)applicationContext.getBean(Context.class));
    }

    private static synchronized void setInstance(Context context) {
        instance = context;
    }

    public Object getBean(String id) {
        return this.applicationContext.containsBean(id) ? this.applicationContext.getBean(id) : this.applicationContext.getBean(Character.toLowerCase(id.charAt(0)) + id.substring(1));
    }

    public boolean containsBean(String id) {
        try {
            return this.applicationContext.containsBean(id) || this.applicationContext.containsBean(Character.toLowerCase(id.charAt(0)) + id.substring(1));
        }
        catch (IllegalStateException ise) {
            return false;
        }
    }

    public List<String> getBeanIds() {
        return Arrays.asList(this.applicationContext.getBeanDefinitionNames());
    }

    public <R> List<R> getBeansOfType(Class<R> requiredType) {
        ArrayList<R> beans = new ArrayList<R>();
        String[] stringArray = this.applicationContext.getBeanNamesForType(requiredType);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            beans.add(requiredType.cast(this.getBean(name)));
            ++n2;
        }
        return beans;
    }

    public <R> R getBean(Class<R> requiredType) {
        if (this.containsBean(requiredType.getSimpleName())) {
            return requiredType.cast(this.getBean(requiredType.getSimpleName()));
        }
        return (R)this.applicationContext.getBean(requiredType);
    }

    public void refresh() {
        if (this.applicationContext != null) {
            try {
                Context.closeCaches();
                ((AbstractApplicationContext)this.applicationContext).stop();
                ((AbstractApplicationContext)this.applicationContext).start();
                ((AbstractApplicationContext)this.applicationContext).refresh();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void closeCaches() {
        CacheManager cm1 = CacheManager.getInstance();
        cm1.shutdown();
        for (CacheManager cm : Context.get().getBeansOfType(CacheManager.class)) {
            cm.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(SystemEventListener evt) {
        Map<SystemEventStatus, LinkedList<SystemEventListener>> map = systemEvents;
        synchronized (map) {
            LinkedList<SystemEventListener> evts = systemEvents.get((Object)evt.getSystemStatus());
            if (evts == null) {
                evts = new LinkedList();
                systemEvents.put(evt.getSystemStatus(), evts);
            }
            evts.add(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(SystemEventListener evt) {
        Map<SystemEventStatus, LinkedList<SystemEventListener>> map = systemEvents;
        synchronized (map) {
            LinkedList<SystemEventListener> evts = systemEvents.get((Object)evt.getSystemStatus());
            if (CollectionUtils.isEmpty(evts)) {
                return;
            }
            evts.remove(evt);
        }
    }

    public Resource[] getResources(String resourcePattern) {
        try {
            return this.applicationContext.getResources(resourcePattern);
        }
        catch (IOException iOException) {
            return new Resource[0];
        }
    }

    public Resource getResource(String resourceLocation) {
        return this.applicationContext.getResource(resourceLocation);
    }

    public synchronized void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextStartedEvent || event instanceof ContextRefreshedEvent) {
            this.processEvents(SystemEventStatus.BEANS_AVAILABLE);
        } else if (event instanceof ContextClosedEvent) {
            this.processEvents(SystemEventStatus.SYSTEM_DESTORY);
        }
    }

    private void processEvents(SystemEventStatus st) {
        LinkedList<SystemEventListener> evts = systemEvents.get((Object)st);
        if (CollectionUtils.isEmpty(evts)) {
            return;
        }
        for (SystemEventListener evt : evts) {
            try {
                evt.processEvent();
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
            }
        }
    }

    public void close() {
        ApplicationContext applicationContext = this.applicationContext;
        if (applicationContext instanceof ConfigurableApplicationContext) {
            ConfigurableApplicationContext configurableContext = (ConfigurableApplicationContext)applicationContext;
            configurableContext.close();
        }
    }
}

