/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.servlet;

import com.logicaldoc.util.io.FileUtil;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServletResponse
implements HttpServletResponse {
    private static final Logger log = LoggerFactory.getLogger(MockServletResponse.class);
    private File output;
    private PrintWriter outputWriter;
    private int contentLength = 0;
    private String contentType;
    private String characterEncoding;
    private Map<String, String> headers = new HashMap<String, String>();
    private int status = 200;

    public MockServletResponse(File output) {
        this.output = output;
    }

    public void flushBuffer() throws IOException {
        if (this.outputWriter != null) {
            this.outputWriter.flush();
        }
    }

    public int getBufferSize() {
        return 0;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return null;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        log.debug("getOutputStream");
        return new ServletOutputStream(){
            private FileOutputStream fileOutputStream;
            {
                this.fileOutputStream = new FileOutputStream(MockServletResponse.this.output, true);
            }

            public void write(int b) throws IOException {
                this.fileOutputStream.write(b);
            }

            public void write(byte[] b) throws IOException {
                this.fileOutputStream.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                this.fileOutputStream.write(b, off, len);
                if (log.isDebugEnabled()) {
                    log.debug("Wrote {}", (Object)new String(b));
                }
            }

            public void flush() throws IOException {
                this.fileOutputStream.flush();
            }

            public void close() throws IOException {
                this.fileOutputStream.close();
            }

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener arg0) {
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        if (this.outputWriter == null) {
            this.outputWriter = new PrintWriter(new FileWriter(this.output));
        }
        return this.outputWriter;
    }

    public boolean isCommitted() {
        return false;
    }

    public void reset() {
    }

    public void resetBuffer() {
    }

    public void setBufferSize(int arg0) {
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLocale(Locale arg0) {
    }

    public void addCookie(Cookie arg0) {
    }

    public void addDateHeader(String arg0, long arg1) {
    }

    public void addHeader(String name, String value) {
        this.setHeader(name, value);
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public void addIntHeader(String arg0, int arg1) {
    }

    public boolean containsHeader(String arg0) {
        return false;
    }

    public String encodeRedirectURL(String arg0) {
        return null;
    }

    public String encodeURL(String arg0) {
        return null;
    }

    public void sendError(int arg0) throws IOException {
    }

    public void sendError(int arg0, String arg1) throws IOException {
    }

    public void sendRedirect(String arg0) throws IOException {
    }

    public void setDateHeader(String arg0, long arg1) {
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    public void setIntHeader(String arg0, int arg1) {
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public String getOutputString() throws IOException {
        if (this.output != null) {
            return FileUtil.readFile(this.output);
        }
        return "";
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setContentLengthLong(long arg0) {
    }

    public Collection<String> getHeaderNames() {
        return new ArrayList<String>();
    }

    public Collection<String> getHeaders(String arg0) {
        return new ArrayList<String>();
    }

    public int getStatus() {
        return this.status;
    }

    public void clear() {
        FileUtil.delete(this.output);
    }

    public void sendRedirect(String arg0, int arg1, boolean arg2) throws IOException {
    }
}

