/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.servlet;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import java.io.IOException;

public class BytesServletInputStream
extends ServletInputStream {
    private byte[] myBytes;
    private int lastIndexRetrieved = -1;
    private ReadListener readListener = null;

    public BytesServletInputStream(byte[] bytes) {
        this.myBytes = bytes;
    }

    public int read() throws IOException {
        if (!this.isFinished()) {
            byte i = this.myBytes[this.lastIndexRetrieved + 1];
            ++this.lastIndexRetrieved;
            if (this.isFinished() && this.readListener != null) {
                try {
                    this.readListener.onAllDataRead();
                }
                catch (IOException ex) {
                    this.readListener.onError((Throwable)ex);
                    throw ex;
                }
            }
            return i;
        }
        return -1;
    }

    public boolean isFinished() {
        return this.lastIndexRetrieved == this.myBytes.length - 1;
    }

    public boolean isReady() {
        return this.isFinished();
    }

    public void setReadListener(ReadListener readListener) {
        this.readListener = readListener;
        if (!this.isFinished()) {
            try {
                readListener.onDataAvailable();
            }
            catch (IOException e) {
                readListener.onError((Throwable)e);
            }
        } else {
            try {
                readListener.onAllDataRead();
            }
            catch (IOException e) {
                readListener.onError((Throwable)e);
            }
        }
    }
}

