/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.plugin;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.config.LogConfigurator;
import com.logicaldoc.util.config.WebConfigurator;
import com.logicaldoc.util.plugin.PluginException;
import com.logicaldoc.util.plugin.PluginRegistry;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Properties;
import org.java.plugin.Plugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogicalDOCPlugin
extends Plugin {
    private static final Logger logger = LoggerFactory.getLogger(LogicalDOCPlugin.class);
    private static final String PLUGIN_PROPERTIES = "plugin.properties";
    private Properties data = new Properties();

    protected void doStart() throws PluginException {
        try {
            this.loadData();
            if (this.isInstallNeeded()) {
                this.install();
                boolean created = this.getInstallMark().createNewFile();
                if (created) {
                    logger.info("Plugin {} installed", (Object)this.getDescriptor().getId());
                } else {
                    logger.error("Cannot install plugin {}", (Object)this.getDescriptor().getId());
                }
            }
            this.onStart();
            this.saveData();
        }
        catch (IOException e) {
            throw new PluginException(e);
        }
    }

    private File getInstallMark() {
        String id = null;
        try {
            ContextProperties conf = new ContextProperties();
            id = conf.getProperty("id");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new File(this.resolveDataPath("install-" + id).toString());
    }

    protected boolean isInstallNeeded() {
        return !this.getInstallMark().exists();
    }

    protected void loadData() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileInputStream fis = new FileInputStream(this.resolveDataFile());){
            this.data.load(fis);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void saveData() throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (FileOutputStream fos = new FileOutputStream(this.resolveDataFile());){
            this.data.store(fos, "");
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getPluginPath() {
        String path = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return path;
    }

    public File resolveDataPath(String relativePath) {
        return new File(this.getDataDirectory(), relativePath);
    }

    private File resolveDataFile() {
        File file = new File(this.getDataDirectory(), PLUGIN_PROPERTIES);
        if (!file.exists()) {
            try {
                boolean created = file.createNewFile();
                if (!created) {
                    throw new IOException("Cannot create new file " + file.getAbsolutePath());
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage());
            }
        }
        return file;
    }

    public File getDataDirectory() {
        String pluginName = this.getPluginName();
        return PluginRegistry.getPluginHome(pluginName);
    }

    protected String getPluginName() {
        return this.getDescriptor().getUniqueId().substring(0, this.getDescriptor().getUniqueId().lastIndexOf(64));
    }

    public void install() throws PluginException {
    }

    protected void onStart() throws PluginException {
    }

    protected void setRestartRequired() {
        if (this.getDescriptor() != null) {
            Logger console = LoggerFactory.getLogger("console");
            console.warn("Plugin {} requires a restart", (Object)this.getDescriptor().getId());
        }
        PluginRegistry.getInstance().setRestartRequired();
    }

    protected void doStop() throws PluginException {
    }

    public Properties getData() {
        return this.data;
    }

    public String getProperty(String name) {
        return this.data.getProperty(name);
    }

    protected void addScheduling(String taskName) {
        try {
            ContextProperties pbean = new ContextProperties();
            pbean.setProperty("schedule.cron." + taskName, "00 00 00 1 * ?");
            pbean.setProperty("schedule.length." + taskName, "-1");
            pbean.setProperty("schedule.enabled." + taskName, "true");
            pbean.setProperty("schedule.mode." + taskName, "simple");
            pbean.setProperty("schedule.interval." + taskName, "1800000");
            pbean.setProperty("schedule.delay." + taskName, "1800000");
            pbean.write();
        }
        catch (IOException e) {
            logger.warn("Cannot add task {} to the configuration", (Object)taskName);
            logger.warn(e.getMessage(), e);
        }
    }

    protected void addLogger(String name, boolean additivity, String level, String appender) {
        try {
            LogConfigurator logging = new LogConfigurator();
            logging.addTextAppender(appender);
            logging.write();
            String appenderWeb = appender + "_WEB";
            logging.addHtmlAppender(appenderWeb);
            logging.write();
            logging.setLogger(name, additivity, level, List.of(appender, appenderWeb));
            logging.write();
        }
        catch (Exception e) {
            logger.warn("Cannot add logger {}", (Object)name);
            logger.warn(e.getMessage(), e);
        }
    }

    protected void addLogger(String name, String appender) {
        try {
            LogConfigurator logging = new LogConfigurator();
            logging.addTextAppender(appender);
            logging.write();
            String appenderWeb = appender + "_WEB";
            logging.addHtmlAppender(appenderWeb);
            logging.write();
            logging.addLogger(name, List.of(appender, appenderWeb));
            logging.write();
        }
        catch (Exception e) {
            logger.warn("Cannot add logger {}", (Object)name);
            logger.warn(e.getMessage(), e);
        }
    }

    protected void addServlet(String name, Class<? extends Servlet> servletClass, String mapping) {
        this.addServlet(name, servletClass, mapping, null);
    }

    protected void addServlet(String name, Class<? extends Servlet> servletClass, String mapping, Integer loadOnStartup) {
        try {
            File webDescriptor = new File(this.getPluginPath());
            webDescriptor = webDescriptor.getParentFile().getParentFile();
            webDescriptor = new File(webDescriptor, "web.xml");
            if (!webDescriptor.exists()) {
                logger.warn("Cannot add servlet {} because no web descriptor located at {}", (Object)name, (Object)webDescriptor.getAbsolutePath());
                return;
            }
            WebConfigurator config = new WebConfigurator(webDescriptor.getAbsolutePath());
            if (loadOnStartup != null) {
                config.addServlet(name, servletClass.getName(), loadOnStartup);
            } else {
                config.addServlet(name, servletClass.getName());
            }
            config.writeXMLDoc();
            if (mapping != null) {
                config.addServletMapping(name, mapping);
                config.writeXMLDoc();
            }
        }
        catch (Exception e) {
            logger.warn("Cannot add servlet {}", (Object)name);
            logger.warn(e.getMessage(), e);
        }
    }
}

