/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.junit;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.plugin.PluginException;
import com.logicaldoc.util.plugin.PluginRegistry;
import com.logicaldoc.util.spring.Context;
import com.logicaldoc.util.time.Pause;
import com.logicaldoc.util.time.TimeDiff;
import jakarta.persistence.PersistenceException;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.io.FilenameUtils;
import org.hsqldb.cmdline.SqlFile;
import org.hsqldb.cmdline.SqlToolError;
import org.junit.After;
import org.junit.Assert;
import org.junit.AssumptionViolatedException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.rules.Stopwatch;
import org.junit.runner.Description;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.util.CollectionUtils;

public abstract class AbstractTestCase {
    private static final Logger log = LoggerFactory.getLogger(AbstractTestCase.class);
    private static final String USER_HOME = "user.home";
    protected ApplicationContext context;
    protected File tempDir = new File("target/tmp");
    protected final String originalUserHome = System.getProperty("user.home");
    @Rule
    public Stopwatch stopwatch = new Stopwatch(){

        protected void succeeded(long nanos, Description description) {
            AbstractTestCase.logDuration(description, "succeeded", nanos);
        }

        protected void failed(long nanos, Throwable e, Description description) {
            AbstractTestCase.logDuration(description, "failed", nanos);
        }

        protected void skipped(long nanos, AssumptionViolatedException e, Description description) {
            AbstractTestCase.logDuration(description, "skipped", nanos);
        }

        protected void finished(long nanos, Description description) {
            AbstractTestCase.logDuration(description, "finished", nanos);
        }
    };

    protected static void logDuration(Description description, String status, long nanos) {
        String testName = description.getClassName() + "#" + description.getMethodName();
        String message = String.format("Test %s %s, spent %s", testName, status, TimeDiff.printDuration(TimeUnit.NANOSECONDS.toMillis(nanos)));
        switch (status) {
            case "failed": {
                log.error(message);
                break;
            }
            case "succeeded": {
                log.debug(message);
                break;
            }
            case "skipped": {
                log.debug(message);
                break;
            }
            default: {
                log.info(message);
            }
        }
    }

    @Before
    public void setUp() throws IOException, SQLException, PluginException {
        System.setProperty("LOGICALDOC_REPOSITORY", "target");
        System.setProperty("java.io.tmpdir", this.tempDir.getAbsolutePath());
        try {
            this.loadDevelSettingsInEnvironment();
            this.updateUserHome();
            this.createTestDirs();
            this.initializePlugins(this.getPluginArchives());
            this.context = this.buildApplicationContext();
            this.loadDevelSettingsInContext();
            this.createDatabase();
        }
        catch (Exception e) {
            this.restoreUserHome();
            log.error(e.getMessage(), e);
            Exception exception = e;
            Objects.requireNonNull(exception);
            Exception exception2 = exception;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IOException.class, SQLException.class, PersistenceException.class}, (Object)exception2, n)) {
                case 0: {
                    IOException ioe = (IOException)exception2;
                    throw ioe;
                }
                case 1: {
                    SQLException sqe = (SQLException)exception2;
                    throw sqe;
                }
                case 2: {
                    PersistenceException pe = (PersistenceException)exception2;
                    throw pe;
                }
            }
            throw new PluginException(e);
        }
    }

    @After
    public void tearDown() throws IOException {
        try {
            try {
                this.destroyDatabase();
                File pluginsDir = new File(Context.get().getProperties().getProperty("conf.plugindir", "target/tests-plugins"));
                FileUtil.delete(pluginsDir);
                if (this.context != null) {
                    ((AbstractApplicationContext)this.context).close();
                }
            }
            catch (Exception exception) {
                this.restoreUserHome();
            }
        }
        finally {
            this.restoreUserHome();
        }
    }

    private void updateUserHome() {
        System.setProperty(USER_HOME, this.tempDir.getPath());
    }

    protected ApplicationContext buildApplicationContext() {
        return new AnnotationConfigApplicationContext(new Class[]{Context.class});
    }

    protected List<String> getPluginArchives() {
        return new ArrayList<String>();
    }

    protected void initializePlugins(List<String> pluginArchives) throws IOException, PluginException {
        if (CollectionUtils.isEmpty(pluginArchives)) {
            return;
        }
        File pluginsDir = new File(new ContextProperties().getProperty("conf.plugindir", "target/tests-plugins"));
        FileUtil.delete(pluginsDir);
        pluginsDir.mkdir();
        for (String pluginArchive : pluginArchives) {
            File pluginFile = new File(pluginsDir, FilenameUtils.getName(pluginArchive));
            FileUtil.copyResource(pluginArchive, pluginFile);
        }
        PluginRegistry registry = PluginRegistry.getInstance();
        registry.init(pluginsDir.getAbsolutePath());
    }

    protected List<String> getDatabaseScripts() {
        return new ArrayList<String>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createDatabase() throws SQLException, IOException {
        List<String> databaseScripts = this.getDatabaseScripts();
        if (CollectionUtils.isEmpty(databaseScripts)) {
            return;
        }
        for (String sqlScript : databaseScripts) {
            File sqlFile = File.createTempFile("sql", ".sql");
            FileUtil.copyResource(sqlScript, sqlFile);
            try {
                Throwable throwable = null;
                Object var6_10 = null;
                try (Connection con = this.getConnection();){
                    SqlFile sql = new SqlFile(sqlFile, "Cp1252", false);
                    sql.setConnection(con);
                    try {
                        log.trace("Running script {}", (Object)sqlScript);
                        sql.execute();
                    }
                    catch (SqlToolError e) {
                        throw new SQLException(e.getMessage(), e);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    } else {
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            finally {
                FileUtil.delete(sqlFile);
            }
        }
        Throwable throwable = null;
        Iterator<String> iterator = null;
        try {
            Connection con = this.getConnection();
            try {
                try (ResultSet rs = con.createStatement().executeQuery("CALL NOW()");){
                    rs.next();
                    Assert.assertNotNull((Object)rs.getObject(1));
                }
                if (con == null) return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                if (con == null) throw throwable;
                con.close();
                throw throwable;
            }
            con.close();
            return;
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
                throw throwable;
            } else {
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    private void loadDevelSettingsInEnvironment() throws IOException {
        Properties devSettings = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader reader = new FileReader(new File(this.originalUserHome + "/logicaldoc-dev.properties"));){
            devSettings.load(reader);
            for (Map.Entry<Object, Object> entry : devSettings.entrySet()) {
                System.setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void loadDevelSettingsInContext() throws IOException {
        Properties devSettings = new Properties();
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader reader = new FileReader(new File(this.originalUserHome + "/logicaldoc-dev.properties"));){
            devSettings.load(reader);
            for (Map.Entry<Object, Object> entry : devSettings.entrySet()) {
                Context.get().getProperties().setProperty(entry.getKey().toString(), entry.getValue().toString());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected void createTestDirs() {
        FileUtil.delete(this.tempDir);
        this.tempDir.mkdirs();
    }

    private void restoreUserHome() {
        System.setProperty(USER_HOME, this.originalUserHome);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void destroyDatabase() {
        if (CollectionUtils.isEmpty(this.getDatabaseScripts())) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try {
                Connection con = this.getConnection();
                try {
                    try (Statement statement = con.createStatement();){
                        statement.execute("shutdown");
                    }
                    if (con == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (con == null) throw throwable;
                    con.close();
                    throw throwable;
                }
                con.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected Connection getConnection() throws SQLException {
        return Context.get(DataSource.class).getConnection();
    }

    protected void waiting() throws InterruptedException {
        Pause.doPause(5000L);
    }
}

