/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import com.logicaldoc.util.io.FileUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;

public class ResourceUtil {
    private ResourceUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static byte[] readAsBytes(String resourceName) throws IOException {
        return ResourceUtil.getInputStream(resourceName).readAllBytes();
    }

    public static String readAsString(String resourceName) throws IOException {
        StringBuilder resourceData = new StringBuilder(1000);
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ResourceUtil.getInputStream(resourceName)));){
            char[] buf = new char[1024];
            int numRead = 0;
            while ((numRead = reader.read(buf)) != -1) {
                resourceData.append(buf, 0, numRead);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return resourceData.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyResource(String resourceName, File out) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            InputStream is = ResourceUtil.getInputStream(resourceName);
            try {
                try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));){
                    int b;
                    while ((b = is.read()) != -1) {
                        ((OutputStream)os).write(b);
                    }
                }
                if (is == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (is == null) throw throwable;
                is.close();
                throw throwable;
            }
            is.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static boolean existsResource(String resourceName) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (InputStream is = ResourceUtil.getInputStream(resourceName);){
                boolean bl = (long)is.available() > 0L;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public static InputStream getInputStream(String resourceName) {
        BufferedInputStream is;
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        try {
            is = new BufferedInputStream(Thread.currentThread().getContextClassLoader().getResourceAsStream(resourceName));
        }
        catch (Exception e) {
            is = new BufferedInputStream(FileUtil.class.getResourceAsStream(resourceName));
        }
        return is;
    }
}

