/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import com.logicaldoc.util.io.IOUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class P7M {
    private static final Logger log = LoggerFactory.getLogger(P7M.class);
    private File file;
    private CMSSignedData cms;
    private byte[] content;

    public P7M(File file) {
        this.file = file;
    }

    public P7M(InputStream is) throws IOException {
        this.read(is);
    }

    public P7M(byte[] content) {
        this.read(content);
    }

    public void read(byte[] content) {
        this.content = content;
        try {
            this.cms = new CMSSignedData(content);
        }
        catch (Exception e) {
            log.error("Error extracting file certificate", e);
        }
    }

    public void read(InputStream is) throws IOException {
        this.content = IOUtil.getBytesOfStream(is);
        try {
            this.read(this.content);
        }
        catch (Exception e) {
            this.content = Base64.decode((byte[])this.content);
            log.debug("Decoding on Base64 completed");
            log.debug("The signed file is in DER format");
            this.read(this.content);
        }
    }

    public void read() throws IOException {
        this.read(new FileInputStream(this.file));
    }

    public InputStream extractOriginalFileStream() throws IOException, CMSException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.cms.getSignedContent().write((OutputStream)os);
        return new ByteArrayInputStream(os.toByteArray());
    }

    public void extractOriginalFile(File outFile) throws IOException, CMSException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileOutputStream os = new FileOutputStream(outFile);){
            this.cms.getSignedContent().write((OutputStream)os);
            os.flush();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public CMSSignedData getCms() {
        return this.cms;
    }
}

