/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LimitedInputStream
extends FilterInputStream {
    private long left;
    private long mark = -1L;

    public LimitedInputStream(InputStream in, long limit) {
        super(in);
        if (in == null) {
            throw new IllegalArgumentException("no input stream");
        }
        if (limit < 0L) {
            throw new IndexOutOfBoundsException("negative limit");
        }
        this.left = limit;
    }

    @Override
    public int available() throws IOException {
        return (int)Math.min((long)this.in.available(), this.left);
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.in.mark(readLimit);
        this.mark = this.left;
    }

    @Override
    public int read() throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read();
        if (result != -1) {
            --this.left;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.left == 0L) {
            return -1;
        }
        int result = this.in.read(b, off, len = (int)Math.min((long)len, this.left));
        if (result != -1) {
            this.left -= (long)result;
        }
        return result;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (!this.in.markSupported()) {
            throw new IOException("Mark not supported");
        }
        if (this.mark == -1L) {
            throw new IOException("Mark not set");
        }
        this.in.reset();
        this.left = this.mark;
    }

    @Override
    public long skip(long n) throws IOException {
        n = Math.min(n, this.left);
        long skipped = this.in.skip(n);
        this.left -= skipped;
        return skipped;
    }

    public static void readFully(InputStream in, byte[] b) throws IOException {
        LimitedInputStream.readFully(in, b, 0, b.length);
    }

    public static void readFully(InputStream in, byte[] b, int off, int len) throws IOException {
        int read = LimitedInputStream.read(in, b, off, len);
        if (read != len) {
            throw new EOFException("reached end of stream after reading " + read + " bytes; " + len + " bytes expected");
        }
    }

    public static void skipFully(InputStream in, long n) throws IOException {
        long skipped = LimitedInputStream.skipUpTo(in, n);
        if (skipped < n) {
            throw new EOFException("reached end of stream after skipping " + skipped + " bytes; " + n + " bytes expected");
        }
    }

    static long skipUpTo(InputStream in, long n) throws IOException {
        long totalSkipped = 0L;
        byte[] buf = LimitedInputStream.createBuffer();
        while (totalSkipped < n) {
            int skip;
            long remaining = n - totalSkipped;
            long skipped = LimitedInputStream.skipSafely(in, remaining);
            if (skipped == 0L && (skipped = (long)in.read(buf, 0, skip = (int)Math.min(remaining, (long)buf.length))) == -1L) break;
            totalSkipped += skipped;
        }
        return totalSkipped;
    }

    private static long skipSafely(InputStream in, long n) throws IOException {
        int available = in.available();
        return available == 0 ? 0L : in.skip(Math.min((long)available, n));
    }

    public static int read(InputStream in, byte[] b, int off, int len) throws IOException {
        if (in == null) {
            throw new IndexOutOfBoundsException("no input stream has been specified");
        }
        if (b == null) {
            throw new IndexOutOfBoundsException("no bytes have been specified");
        }
        if (len < 0) {
            throw new IndexOutOfBoundsException("len is negative");
        }
        int total = 0;
        while (total < len) {
            int result = in.read(b, off + total, len - total);
            if (result == -1) break;
            total += result;
        }
        return total;
    }

    private static byte[] createBuffer() {
        return new byte[8192];
    }
}

