/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.spring.Context;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;

public class JarUtil {
    private int maxEntries = 100000;
    private int maxSize = 0x40000000;
    private double maxCompressionRatio = 30.0;

    public JarUtil() {
        try {
            this.maxEntries = Context.get().getProperties().getInt("zip.maxentries", 100000);
            this.maxSize = Context.get().getProperties().getInt("zip.maxsize", 1024) * 1024 * 1024;
            this.maxCompressionRatio = Context.get().getProperties().getDouble("zip.maxratio", 30.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void unjar(String jarsource, String target) throws IOException {
        int totalSizeArchive = 0;
        int totalEntryArchive = 0;
        File targetDir = new File(target);
        if (targetDir.exists() && targetDir.isFile()) {
            FileUtil.delete(targetDir);
        }
        if (!targetDir.exists()) {
            FileUtils.forceMkdir(targetDir);
        }
        Throwable throwable = null;
        Object var7_8 = null;
        try (JarFile jar = new JarFile(jarsource);){
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry je = entries.nextElement();
                File file = new File(targetDir.getPath() + File.separatorChar + je.getName());
                if (je.isDirectory()) {
                    file.mkdirs();
                } else {
                    file.getParentFile().mkdirs();
                    totalSizeArchive = (int)((long)totalSizeArchive + this.extractEntry(jar, je, file.getPath()));
                }
                ++totalEntryArchive;
                if (totalSizeArchive > this.maxSize) {
                    throw new IOException(String.format("Jar file %s looks like a Zip Bomb Attack: the uncompressed data size is over the maximum allowed of %s", jarsource, FileUtil.getDisplaySize(this.maxSize, "en")));
                }
                if (totalEntryArchive <= this.maxEntries) continue;
                throw new IOException(String.format("Jar file %s looks like a Zip Bomb Attack: can lead to inodes exhaustion of the system and is over the maximum allowed of %d", jarsource, this.maxEntries));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void unjar(String jarsource, String entry, String target) throws IOException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (JarFile jar = new JarFile(jarsource);){
            JarEntry jare = new JarEntry(entry);
            this.extractEntry(jar, jare, target);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Exception decompiling
     */
    private long extractEntry(JarFile jar, JarEntry je, String target) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

