/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.LimitedInputStream;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtil {
    private static final int DEFAULT_BUFFER_SIZE = 10240;
    private static final Logger log = LoggerFactory.getLogger(IOUtil.class);

    private IOUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void close(Closeable resource) {
        if (resource != null) {
            try {
                resource.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static InputStream getLimitedStream(InputStream input, long limit) {
        return new LimitedInputStream(input, limit);
    }

    public static void write(InputStream input, OutputStream output) throws IOException {
        int totalBytes = 0;
        byte[] buffer = new byte[10240];
        while ((totalBytes = input.read(buffer)) != -1) {
            output.write(buffer, 0, totalBytes);
        }
    }

    public static void write(InputStream input, File output) throws IOException {
        Files.copy(input, output.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static String readStream(InputStream is) throws IOException {
        return IOUtils.toString(is, StandardCharsets.UTF_8);
    }

    /*
     * Exception decompiling
     */
    public static byte[] getBytesOfStream(InputStream stream) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String serialize(Serializable object, String charset) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Throwable throwable = null;
        Object var4_5 = null;
        try (XMLEncoder encoder = new XMLEncoder(baos, StringUtils.defaultString(charset, "UTF-8"), false, 0);){
            encoder.setExceptionListener(e -> log.warn(e.getMessage(), e));
            encoder.writeObject(object);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return baos.toString().trim().replace("\n", "");
    }

    public static Object deserialize(String xml) {
        Throwable throwable = null;
        Object var2_3 = null;
        try (XMLDecoder decoder = new XMLDecoder(new ByteArrayInputStream(xml.getBytes()));){
            return decoder.readObject();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void download(String url, File dest, int timeout, int bufferSize) throws IOException, URISyntaxException {
        if (url == null || url.isEmpty()) {
            throw new IOException("Url argument is not specified");
        }
        URL uri = new URI(url).toURL();
        HttpURLConnection connection = (HttpURLConnection)uri.openConnection();
        if (timeout > 0) {
            connection.setConnectTimeout(timeout);
        }
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (InputStream stream = connection.getInputStream();){
                int statusCode = connection.getResponseCode();
                if (statusCode != 200) {
                    connection.disconnect();
                    throw new IOException("Document editing service returned status: " + statusCode);
                }
                if (stream == null) {
                    throw new IOException("Input stream is null");
                }
                FileUtil.writeFile(IOUtil.getAllBytes(stream, bufferSize), dest.getAbsolutePath());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            connection.disconnect();
        }
    }

    private static byte[] getAllBytes(InputStream is, int bufferSize) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[bufferSize];
        int len = is.read(buffer);
        while (len != -1) {
            os.write(buffer, 0, len);
            len = is.read(buffer);
        }
        return os.toByteArray();
    }
}

