/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.io;

import com.logicaldoc.util.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class AutoDeleteInputStream
extends InputStream {
    private InputStream wrappedStream;
    private File file;

    public AutoDeleteInputStream(File file) throws FileNotFoundException {
        this.file = file;
        this.wrappedStream = new FileInputStream(file);
    }

    public AutoDeleteInputStream(InputStream wrappedStream, File file) {
        this.wrappedStream = wrappedStream;
        this.file = file;
    }

    @Override
    public int read() throws IOException {
        return this.wrappedStream.read();
    }

    public int hashCode() {
        return this.wrappedStream.hashCode();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.wrappedStream.read(b);
    }

    public boolean equals(Object obj) {
        return this.wrappedStream.equals(obj);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.wrappedStream.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.wrappedStream.skip(n);
    }

    public String toString() {
        return this.wrappedStream.toString();
    }

    @Override
    public int available() throws IOException {
        return this.wrappedStream.available();
    }

    @Override
    public void close() throws IOException {
        this.wrappedStream.close();
        if (this.file != null) {
            FileUtil.delete(this.file);
        }
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.wrappedStream.mark(readlimit);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.wrappedStream.reset();
    }

    @Override
    public boolean markSupported() {
        return this.wrappedStream.markSupported();
    }
}

