/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.http;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class UrlUtil {
    private static final String UTF_8 = "UTF-8";

    private UrlUtil() {
    }

    public static Map<String, List<String>> getQueryParams(String url) {
        try {
            HashMap<String, List<String>> params = new HashMap<String, List<String>>();
            String[] urlParts = url.split("\\?");
            if (urlParts.length > 1) {
                String query = urlParts[1];
                String[] stringArray = query.split("&");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ArrayList<String> values;
                    String param = stringArray[n2];
                    String[] pair = param.split("=");
                    String key = URLDecoder.decode(pair[0], UTF_8);
                    String value = "";
                    if (pair.length > 1) {
                        value = URLDecoder.decode(pair[1], UTF_8);
                    }
                    if ((values = (ArrayList<String>)params.get(key)) == null) {
                        values = new ArrayList<String>();
                        params.put(key, values);
                    }
                    values.add(value);
                    ++n2;
                }
            }
            return params;
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static Map<String, String> getParams(String urlString) throws UnsupportedEncodingException, MalformedURLException, URISyntaxException {
        String[] pairs;
        URL url = UrlUtil.toURL(urlString);
        LinkedHashMap<String, String> queryPairs = new LinkedHashMap<String, String>();
        String query = url.getQuery();
        String[] stringArray = pairs = query.split("&");
        int n = pairs.length;
        int n2 = 0;
        while (n2 < n) {
            String pair = stringArray[n2];
            int idx = pair.indexOf("=");
            queryPairs.put(URLDecoder.decode(pair.substring(0, idx), UTF_8), URLDecoder.decode(pair.substring(idx + 1), UTF_8));
            ++n2;
        }
        return queryPairs;
    }

    public static String getQueryParam(String url, String parameter) throws MalformedURLException, URISyntaxException {
        try {
            return UrlUtil.getParams(url).get(parameter);
        }
        catch (UnsupportedEncodingException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public static String encode(String s, String enc) throws UnsupportedEncodingException {
        return URLEncoder.encode(s, enc);
    }

    public static String normalize(String inputUrl) throws URISyntaxException, MalformedURLException {
        return UrlUtil.toURL(inputUrl).toString();
    }

    public static URL toURL(String urlSpec) throws MalformedURLException, URISyntaxException {
        URI inputUri = new URI(urlSpec.replace("\\", "/"));
        URI normalizedUri = inputUri.normalize();
        return normalizedUri.toURL();
    }
}

