/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.http;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.spring.Context;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.lang.StringUtils;
import org.apache.hc.client5.http.auth.AuthCache;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.impl.routing.DefaultProxyRoutePlanner;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.RedirectStrategy;
import org.apache.hc.client5.http.routing.HttpRoutePlanner;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.NoopHostnameVerifier;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactoryBuilder;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.TrustStrategy;

public class HttpUtil {
    private HttpUtil() {
    }

    private static String[] getProxy() {
        String[] stringArray = new String[4];
        stringArray[1] = "0";
        String[] proxy = stringArray;
        ContextProperties config = null;
        try {
            config = Context.get().getProperties();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (config == null) {
                config = new ContextProperties();
            }
            if (config.getBoolean("proxy.enabled", false)) {
                proxy[0] = config.getProperty("proxy.host");
                proxy[1] = config.getProperty("proxy.port");
                proxy[2] = config.getProperty("proxy.username");
                proxy[3] = config.getProperty("proxy.password");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            proxy[1] = "" + Integer.parseInt(proxy[1]);
        }
        catch (Exception t) {
            proxy[1] = "0";
        }
        return proxy;
    }

    public static CloseableHttpClient getNotValidatingClient(int timeout, String proxyServer, Integer proxyPort, String proxyUser, String proxyPassword) {
        try {
            ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout((long)timeout, TimeUnit.SECONDS).setSocketTimeout(timeout, TimeUnit.SECONDS).build();
            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout((long)timeout, TimeUnit.SECONDS).setResponseTimeout((long)timeout, TimeUnit.SECONDS).build();
            SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(timeout, TimeUnit.SECONDS).build();
            PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = PoolingHttpClientConnectionManagerBuilder.create().setDefaultConnectionConfig(connectionConfig).setDefaultSocketConfig(socketConfig).build();
            HttpClientBuilder clientBuilder = HttpClientBuilder.create().setRedirectStrategy((RedirectStrategy)new DefaultRedirectStrategy()).setConnectionManager((HttpClientConnectionManager)poolingHttpClientConnectionManager).setDefaultRequestConfig(requestConfig);
            if (StringUtils.isNotEmpty(proxyServer)) {
                HttpHost proxyHost = new HttpHost(proxyServer, proxyPort.intValue());
                DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxyHost);
                if (StringUtils.isNotEmpty(proxyUser)) {
                    CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().add(new AuthScope(proxyHost), proxyUser, proxyPassword.toCharArray()).build();
                    BasicAuthCache authCache = new BasicAuthCache();
                    BasicScheme basicAuth = new BasicScheme();
                    authCache.put(proxyHost, (AuthScheme)basicAuth);
                    HttpClientContext context = HttpClientContext.create();
                    context.setCredentialsProvider(credentialsProvider);
                    context.setAuthCache((AuthCache)authCache);
                    clientBuilder = clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner).setDefaultCredentialsProvider(credentialsProvider);
                } else {
                    clientBuilder = clientBuilder.setRoutePlanner((HttpRoutePlanner)routePlanner);
                }
            }
            clientBuilder = clientBuilder.setConnectionManager((HttpClientConnectionManager)PoolingHttpClientConnectionManagerBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)SSLConnectionSocketFactoryBuilder.create().setSslContext(SSLContextBuilder.create().loadTrustMaterial((TrustStrategy)TrustAllStrategy.INSTANCE).build()).setHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build()).build());
            return clientBuilder.build();
        }
        catch (Exception t) {
            return null;
        }
    }

    public static CloseableHttpClient getNotValidatingClient(int timeout) {
        String[] proxy = HttpUtil.getProxy();
        return HttpUtil.getNotValidatingClient(timeout, proxy[0], Integer.parseInt(proxy[1]), proxy[2], proxy[3]);
    }

    public static void close(ClassicHttpResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static String getBodyString(ClassicHttpResponse response) {
        HttpEntity rent = response.getEntity();
        if (rent != null) {
            String respBody = "";
            try {
                respBody = EntityUtils.toString((HttpEntity)rent, (String)"UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return respBody;
        }
        return "";
    }

    public static InputStream getBodyStream(ClassicHttpResponse response) throws IllegalStateException, IOException {
        HttpEntity rent = response.getEntity();
        if (rent != null) {
            return rent.getContent();
        }
        return null;
    }
}

