/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.http;

import com.logicaldoc.util.MimeType;
import com.logicaldoc.util.http.FileBodyCounter;
import com.logicaldoc.util.http.HttpUtil;
import com.logicaldoc.util.http.StringHttpClientResponseHandler;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.MultipartEntityBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUpload {
    private static final Logger log = LoggerFactory.getLogger(HttpUpload.class);
    private static final String UTF_8 = "UTF-8";
    private static final int TIMEOUT = 20;
    private String url;
    private File file;
    private String fileName;
    private FileBodyCounter.ProgressListener listener;

    public void upload() throws IOException {
        HttpPost filePost = new HttpPost(this.url);
        String f = this.fileName;
        if (f == null) {
            f = this.file.getName();
        }
        String name = "LDOC-" + new Date().getTime();
        FileBody filePart = null;
        filePart = this.listener != null ? new FileBodyCounter(this.file, ContentType.create((String)MimeType.getByFilename(f), (String)UTF_8), name, this.listener) : new FileBody(this.file, ContentType.create((String)MimeType.getByFilename(f), (String)UTF_8), name);
        HttpEntity reqEntity = MultipartEntityBuilder.create().addPart(name, (ContentBody)filePart).build();
        filePost.setEntity(reqEntity);
        CloseableHttpClient client = HttpUtil.getNotValidatingClient(20);
        client.execute((ClassicHttpRequest)filePost, (HttpClientResponseHandler)new StringHttpClientResponseHandler(){

            public String handleResponse(ClassicHttpResponse response) throws IOException {
                int status = response.getCode();
                String respBody = "";
                HttpEntity rent = response.getEntity();
                if (rent != null) {
                    try {
                        respBody = EntityUtils.toString((HttpEntity)rent, (String)HttpUpload.UTF_8);
                    }
                    catch (ParseException e) {
                        throw new IOException(e);
                    }
                }
                if (status != 200) {
                    log.debug("Upload failed, response: {}", (Object)status);
                    throw new IOException("" + status);
                }
                log.debug("Upload complete, response: {}", (Object)respBody);
                return respBody;
            }
        });
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public FileBodyCounter.ProgressListener getListener() {
        return this.listener;
    }

    public void setListener(FileBodyCounter.ProgressListener listener) {
        this.listener = listener;
    }
}

