/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.http;

import java.io.File;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.core5.http.ContentType;

public class FileBodyCounter
extends FileBody {
    private long byteCount;
    private ProgressListener listener;

    public FileBodyCounter(File file, ContentType contentType, String filename, ProgressListener listener) {
        super(file, contentType, filename);
        this.listener = listener;
    }

    public FileBodyCounter(File file, ProgressListener listener) {
        super(file);
        this.listener = listener;
    }

    public long getBytesWritten() {
        return this.byteCount;
    }

    public void writeTo(OutputStream out) throws IOException {
        super.writeTo((OutputStream)new FilterOutputStream(out){

            @Override
            public void write(int b) throws IOException {
                ++FileBodyCounter.this.byteCount;
                super.write(b);
                FileBodyCounter.this.listener.transferred(FileBodyCounter.this.byteCount, 1L);
            }
        });
    }

    public static interface ProgressListener {
        public void transferred(long var1, long var3);
    }
}

