/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.html;

import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;

public class HTMLSanitizer {
    private HTMLSanitizer() {
    }

    public static String sanitize(String unsafeHtmlContent) {
        if (StringUtils.isEmpty(unsafeHtmlContent)) {
            return unsafeHtmlContent;
        }
        Safelist whiteList = Safelist.relaxed().preserveRelativeLinks(true);
        whiteList = whiteList.addTags(new String[]{"head", "html", "style", "body", "fieldsMap", "area"});
        whiteList = whiteList.addAttributes(":all", new String[]{"name", "class", "style", "id", "src", "type", "cellpadding", "cellspacing", "alt", "title", "shape", "coords", "width", "height", "dir"});
        whiteList = whiteList.addProtocols("img", "src", new String[]{"http", "https", "data", "cid"});
        return Jsoup.clean((String)unsafeHtmlContent, (Safelist)whiteList);
    }

    public static String sanitizeSimpleText(String unsafeHtmlContent) {
        if (StringUtils.isEmpty(unsafeHtmlContent)) {
            return unsafeHtmlContent;
        }
        Document.OutputSettings outputSettings = new Document.OutputSettings().indentAmount(0).prettyPrint(false);
        Safelist whiteList = Safelist.simpleText().preserveRelativeLinks(false);
        String previousSanitized = "";
        String sanitized = StringEscapeUtils.unescapeHtml(Jsoup.clean((String)unsafeHtmlContent, (String)"", (Safelist)whiteList, (Document.OutputSettings)outputSettings));
        while (!previousSanitized.equals(sanitized)) {
            previousSanitized = sanitized;
            sanitized = StringEscapeUtils.unescapeHtml(Jsoup.clean((String)previousSanitized, (String)"", (Safelist)whiteList, (Document.OutputSettings)outputSettings));
        }
        return sanitized;
    }

    public static String stripIframes(String htmlContent) {
        if (StringUtils.isEmpty(htmlContent)) {
            return htmlContent;
        }
        Document doc = Jsoup.parse((String)htmlContent, (String)"UTF-8");
        doc.select("iframe").remove();
        return doc.text();
    }
}

