/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.html;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public class HTMLColor {
    private static Map<String, Color> colorNames = new HashMap<String, Color>();

    static {
        colorNames.put("black", new Color(0));
        colorNames.put("green", new Color(32768));
        colorNames.put("silver", new Color(0xC0C0C0));
        colorNames.put("lime", new Color(65280));
        colorNames.put("gray", new Color(0x808080));
        colorNames.put("olive", new Color(0x808000));
        colorNames.put("white", new Color(0xFFFFFF));
        colorNames.put("yellow", new Color(0xFFFF00));
        colorNames.put("maroon", new Color(0x800000));
        colorNames.put("navy", new Color(128));
        colorNames.put("red", new Color(0xFF0000));
        colorNames.put("blue", new Color(255));
        colorNames.put("purple", new Color(0x800080));
        colorNames.put("teal", new Color(32896));
        colorNames.put("fuchsia", new Color(0xFF00FF));
        colorNames.put("aqua", new Color(65535));
    }

    private HTMLColor() {
    }

    public static Color decode(String color) {
        if (color == null) {
            throw new IllegalArgumentException("NULL_COLOR_PARAMETER_ERROR");
        }
        Color c = colorNames.get(color.trim().toLowerCase());
        if (c == null) {
            try {
                c = Color.decode(color.trim());
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("DECODE_COLOR_PARAMETER_ERROR");
            }
        }
        return c;
    }

    public static Integer integerValue(String color) {
        return HTMLColor.decode(color).getRGB();
    }

    public static String encodeRGB(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("NULL_COLOR_PARAMETER_ERROR_2");
        }
        return "#" + Integer.toHexString(color.getRGB()).substring(2).toUpperCase();
    }
}

