/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.exec;

import com.logicaldoc.util.exec.ExecException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaLauncher {
    private static final Logger log = LoggerFactory.getLogger(JavaLauncher.class);
    private static boolean debug = false;

    public static Process exec(String mainClass, String classpath, String[] jvmargs, String[] properties) throws ExecException {
        String jvm = JavaLauncher.findJVM();
        StringBuilder strClasspath = new StringBuilder("." + File.pathSeparator + classpath);
        String[] allArguments = new String[properties.length + jvmargs.length];
        System.arraycopy(jvmargs, 0, allArguments, 0, jvmargs.length);
        System.arraycopy(properties, 0, allArguments, jvmargs.length, properties.length);
        String[] command = new String[5 + allArguments.length];
        command[0] = jvm;
        System.arraycopy(allArguments, 0, command, 1, allArguments.length);
        command[allArguments.length + 2] = "-classpath";
        command[allArguments.length + 3] = "\"" + String.valueOf(strClasspath) + "\"";
        command[allArguments.length + 4] = mainClass;
        StringBuilder wholeCommand = new StringBuilder();
        int i = 0;
        while (i < command.length) {
            wholeCommand.append(command[i] + " ");
            ++i;
        }
        log.info("Executing Command: {}", (Object)wholeCommand);
        try {
            Process proc = Runtime.getRuntime().exec(command);
            if (debug) {
                JavaLauncher.monitorProcess(proc);
            }
            return proc;
        }
        catch (Exception e) {
            throw new ExecException(wholeCommand.toString(), e);
        }
    }

    public static Process execJar(String pathToJar, String[] jvmargs) throws ExecException {
        String jvm = JavaLauncher.findJVM();
        String[] command = new String[jvmargs.length + 3];
        command[0] = jvm;
        System.arraycopy(jvmargs, 0, command, 1, jvmargs.length);
        command[jvmargs.length + 1] = "-jar";
        command[jvmargs.length + 2] = new File(pathToJar).getAbsolutePath();
        StringBuilder wholeCommand = new StringBuilder();
        int i = 0;
        while (i < command.length) {
            wholeCommand.append(command[i] + " ");
            ++i;
        }
        log.info("Executing command: {}", (Object)wholeCommand);
        try {
            Process proc = Runtime.getRuntime().exec(command);
            if (debug) {
                JavaLauncher.monitorProcess(proc);
            }
            return proc;
        }
        catch (Exception e) {
            throw new ExecException(wholeCommand.toString(), e);
        }
    }

    private static void monitorProcess(Process proc) throws IOException {
        String line;
        proc.getInputStream().close();
        proc.getErrorStream().close();
        InputStream inputstream = proc.getErrorStream();
        InputStreamReader inputstreamreader = new InputStreamReader(inputstream);
        BufferedReader bufferedreader = new BufferedReader(inputstreamreader);
        while ((line = bufferedreader.readLine()) != null) {
            log.info(line);
        }
        try {
            if (proc.waitFor() != 0) {
                log.info("exit value = {}", (Object)proc.exitValue());
            }
        }
        catch (InterruptedException e) {
            log.error(e.getMessage());
            Thread.currentThread().interrupt();
        }
    }

    public static String findJVM() {
        String jvm = null;
        jvm = System.getProperty("java.home");
        if (jvm == null) {
            log.warn("Java home property not set, just guessing with a general java call, and will probably fail.");
            jvm = "java";
        }
        return jvm + File.separator + "bin" + File.separator + "java";
    }

    public static void main(String[] args) {
        try {
            String[] jvmargs = new String[]{"-Xms256m", "-Xmx1024m", "-Ddebug=true"};
            Process proc = JavaLauncher.execJar("Updater.jar", jvmargs);
            JavaLauncher.monitorProcess(proc);
        }
        catch (Exception e) {
            log.error("Failed to launch java program: {}", (Object)e.getMessage());
        }
    }
}

