/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.csv;

import com.logicaldoc.util.csv.CSVFile;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class CSVFileWriter
extends CSVFile
implements Closeable {
    protected PrintWriter out;

    public CSVFileWriter(String outputFileName) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), StandardCharsets.UTF_8);
        this.out = new PrintWriter(new BufferedWriter(osw));
    }

    public CSVFileWriter(String outputFileName, char sep) throws IOException {
        super(sep);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), StandardCharsets.UTF_8);
        this.out = new PrintWriter(new BufferedWriter(osw));
    }

    public CSVFileWriter(String outputFileName, char sep, char qual) throws IOException {
        super(sep, qual);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName), StandardCharsets.UTF_8);
        this.out = new PrintWriter(new BufferedWriter(osw));
    }

    public CSVFileWriter(String outputFileName, boolean append) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName, append), StandardCharsets.UTF_8);
        this.out = new PrintWriter(new BufferedWriter(osw));
    }

    public CSVFileWriter(String outputFileName, char sep, boolean append) throws IOException {
        super(sep);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName, append), StandardCharsets.UTF_8);
        this.out = new PrintWriter(new BufferedWriter(osw));
    }

    public CSVFileWriter(String outputFileName, char sep, char qual, boolean append) throws IOException {
        super(sep, qual);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFileName, append), StandardCharsets.UTF_8);
        this.out = new PrintWriter(new BufferedWriter(osw));
    }

    @Override
    public void close() throws IOException {
        this.out.flush();
        this.out.close();
    }

    public void writeFields(List<String> fields) {
        int n = fields.size();
        int i = 0;
        while (i < n) {
            this.out.print(this.textQualifier + fields.get(i) + this.textQualifier);
            if (i < n - 1) {
                this.out.print(this.fieldSeparator);
            }
            ++i;
        }
        this.out.println();
    }
}

