/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.csv;

import com.logicaldoc.util.csv.CSVFile;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

public class CSVFileReader
extends CSVFile
implements Closeable {
    protected BufferedReader in;

    public CSVFileReader(String inputFileName) throws FileNotFoundException, UnsupportedEncodingException {
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(inputFileName), StandardCharsets.UTF_8);
        this.in = new BufferedReader(isr);
    }

    public CSVFileReader(String inputFileName, char sep) throws FileNotFoundException, UnsupportedEncodingException {
        super(sep);
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(inputFileName), StandardCharsets.UTF_8);
        this.in = new BufferedReader(isr);
    }

    public CSVFileReader(String inputFileName, char sep, char qual) throws FileNotFoundException, UnsupportedEncodingException {
        super(sep, qual);
        InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(inputFileName), StandardCharsets.UTF_8);
        this.in = new BufferedReader(isr);
    }

    public List<String> readFields() throws IOException {
        ArrayList<String> fields = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        String line = this.in.readLine();
        if (line == null) {
            return new ArrayList<String>();
        }
        if (line.length() == 0) {
            fields.add(line);
            return fields;
        }
        int i = 0;
        do {
            sb.setLength(0);
            if (i < line.length() && line.charAt(i) == this.textQualifier) {
                ++i;
                i = this.handleQuotedField(line, sb, i);
            } else {
                i = this.handlePlainField(line, sb, i);
            }
            fields.add(sb.toString());
        } while (++i < line.length());
        return fields;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    protected int handleQuotedField(String s, StringBuilder sb, int i) {
        int len = s.length();
        int j = i;
        while (j < len) {
            boolean stopCycle = false;
            if (s.charAt(j) == this.textQualifier && j + 1 < len) {
                if (s.charAt(j + 1) == this.textQualifier) {
                    ++j;
                } else if (s.charAt(j + 1) == this.fieldSeparator) {
                    ++j;
                    stopCycle = true;
                }
            } else if (s.charAt(j) == this.textQualifier && j + 1 == len) {
                stopCycle = true;
            }
            if (stopCycle) break;
            sb.append(s.charAt(j));
            ++j;
        }
        return j;
    }

    protected int handlePlainField(String s, StringBuilder sb, int i) {
        int j = s.indexOf(this.fieldSeparator, i);
        if (j == -1) {
            sb.append(s.substring(i));
            return s.length();
        }
        sb.append(s.substring(i, j));
        return j;
    }
}

