/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.config;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.jdom2.Attribute;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLBean {
    private static final Logger log = LoggerFactory.getLogger(XMLBean.class);
    private Document doc;
    private Element root;
    private String docPath;
    private InputStream docInputStream = null;

    public XMLBean(String docPath) {
        this.docPath = docPath;
        this.docInputStream = null;
        this.initDocument();
    }

    public XMLBean(URL docname) {
        try {
            this.docPath = URLDecoder.decode(docname.getPath(), "UTF-8");
            this.docInputStream = null;
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
        this.initDocument();
    }

    public XMLBean(InputStream is) {
        this.docInputStream = is;
        this.docPath = null;
        this.initDocument();
    }

    private void initDocument() {
        SAXBuilder builder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        builder.setFeature("http://xml.org/sax/features/validation", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        builder.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        builder.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", (Object)"");
        builder.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", (Object)"");
        if (this.docPath != null) {
            try {
                this.doc = builder.build(this.docPath);
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
                this.buildFromFileUrl(builder);
            }
        } else {
            try {
                this.doc = builder.build(this.docInputStream);
            }
            catch (Exception t) {
                log.error(t.getMessage(), t);
            }
        }
        this.root = this.doc.getRootElement();
    }

    private void buildFromFileUrl(SAXBuilder builder) {
        try {
            this.doc = builder.build("file://" + this.docPath);
        }
        catch (Exception t2) {
            log.error(t2.getMessage());
        }
    }

    public Element findElement(String xpathExpression) {
        return this.findElement(xpathExpression, null);
    }

    public Element findElement(String xpathExpression, Map<String, String> namespaces) {
        try {
            XPathFactory xpath = XPathFactory.instance();
            XPathExpression expr = null;
            expr = namespaces == null || namespaces.isEmpty() ? xpath.compile(xpathExpression, Filters.element()) : xpath.compile(xpathExpression, Filters.element(), null, namespaces.keySet().stream().map(key -> Namespace.getNamespace((String)key, (String)((String)namespaces.get(key)))).toList());
            return (Element)expr.evaluateFirst((Object)this.doc);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    public Element getRootElement() {
        return this.root;
    }

    public Element getChild(String elemname) {
        if (this.doc == null) {
            return null;
        }
        return this.root.getChild(elemname);
    }

    private List<Element> getChildren(Element elem, String name) {
        List list = elem.getChildren(name, elem.getNamespace());
        if (list == null || list.isEmpty()) {
            list = elem.getChildren(name);
        }
        return list;
    }

    public Element getChild(String elemname, String attribute, String value) {
        if (this.doc == null) {
            return null;
        }
        Element temp = null;
        List<Element> list = this.getChildren(this.root, elemname);
        Iterator<Element> iter = list.iterator();
        String val = "";
        while (iter.hasNext()) {
            Element elem = iter.next();
            val = elem.getAttributeValue(attribute);
            if (val == null || !val.equals(value)) continue;
            temp = elem;
            break;
        }
        return temp;
    }

    public String getText(Element elem) {
        if (this.doc == null) {
            return null;
        }
        return elem.getText();
    }

    public String getText(String elemname, String attrname, String attrvalue) {
        Element elem = this.getChild(elemname, attrname, attrvalue);
        return elem.getText();
    }

    public String getChildText(String elemname, String childname, String attribute, String value) {
        Element elem = this.getChild(elemname, attribute, value);
        elem = elem.getChild(childname);
        return this.getText(elem);
    }

    public String getAllChildText(String elemname, String attribute, String value, String separator1, String separator2) {
        StringBuilder result = new StringBuilder();
        try {
            Element elem = this.getChild(elemname, attribute, value);
            List list = elem.getChildren();
            for (Element child : list) {
                result.append(child.getName());
                result.append(separator1);
                result.append(child.getText());
                result.append(separator2);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
        }
        return result.toString();
    }

    public Attribute getAttribute(Element elem, String attrib) {
        if (this.doc == null) {
            return null;
        }
        return elem.getAttribute(attrib);
    }

    public String getAttributeValue(Element elem, String attrib) {
        if (this.doc == null) {
            return null;
        }
        return elem.getAttributeValue(attrib);
    }

    public void setAttributeValue(Element elem, String attrib, String value) {
        elem.getAttribute(attrib).setValue(value);
    }

    public void setText(Element elem, String text) {
        elem.setText(text);
    }

    public boolean writeXMLDoc() {
        boolean result;
        block5: {
            if (this.docPath == null) {
                return false;
            }
            File src = new File(this.docPath);
            File backup = new File(src.getParentFile(), src.getName() + ".back");
            try {
                FileUtils.copyFile(src, backup);
            }
            catch (Exception ex) {
                log.error(ex.getMessage());
            }
            log.debug("Backup saved in {}", (Object)backup.getPath());
            result = true;
            try {
                XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat().setIndent("  ").setLineSeparator("\n"));
                File file = new File(this.docPath);
                FileOutputStream out = new FileOutputStream(file);
                outputter.output(this.doc, (OutputStream)out);
                ((OutputStream)out).close();
                log.info("Saved file {}", (Object)this.docPath);
            }
            catch (Exception ex) {
                result = false;
                if (!log.isWarnEnabled()) break block5;
                log.warn(ex.getMessage());
            }
        }
        return result;
    }

    public List<Element> getRootChild() {
        if (this.doc == null) {
            return new ArrayList<Element>();
        }
        return this.root.getChildren();
    }

    public List<Attribute> getAllAttribute(Element elem) {
        if (this.doc == null) {
            return new ArrayList<Attribute>();
        }
        return elem.getAttributes();
    }

    public List<Element> getAllChildren(String elemname) {
        if (this.doc == null) {
            return new ArrayList<Element>();
        }
        return this.root.getChildren(elemname);
    }

    public List<Element> getAllChildren(String elemname, String attribute, String value) {
        LinkedList<Element> list = new LinkedList<Element>();
        List elems = this.root.getChildren(elemname);
        for (Element elem : elems) {
            try {
                String val = elem.getAttributeValue(attribute);
                if (val == null || !val.equals(value)) continue;
                list.add(elem);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return list;
    }

    public boolean removeChild(String elemname) {
        return this.root.removeChild(elemname);
    }
}

