/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.config;

import com.logicaldoc.util.config.XMLBean;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;

public class WebConfigurator
extends XMLBean {
    private static final String INIT_PARAM_STR = "init-param";
    private static final String URL_PATTERN = "url-pattern";
    private static final String LISTENER_CLASS = "listener-class";
    private static final String LISTENER = "listener";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String SERVLET = "servlet";
    private static final String DESCRIPTION = "description";
    private static final String FILTER_NAME = "filter-name";
    private static final String FILTER = "filter";
    private static final String PARAM_VALUE = "param-value";
    private static final String PARAM_NAME = "param-name";

    public WebConfigurator(String path) {
        super(path);
    }

    private Element elementLookUp(List<Element> elements, String matchText, String name) {
        for (Element elem : elements) {
            Element elementName = elem.getChild(matchText, elem.getNamespace());
            if (elementName == null || !elementName.getText().trim().equals(name)) continue;
            return elem;
        }
        return null;
    }

    public void addContextParam(String name, String value, String description, INIT_PARAM append) {
        List contextParams = this.getRootElement().getChildren("context-param", this.getRootElement().getNamespace());
        Element contextParam = this.elementLookUp(contextParams, PARAM_NAME, name);
        if (contextParam != null && append.equals((Object)INIT_PARAM.PARAM_STOP)) {
            return;
        }
        if (contextParam == null) {
            Element lastContextParam = (Element)contextParams.get(contextParams.size() - 1);
            List children = this.getRootElement().getChildren();
            int index = children.indexOf(lastContextParam);
            contextParam = new Element("context-param", this.getRootElement().getNamespace());
            Element paramName = new Element(PARAM_NAME, this.getRootElement().getNamespace());
            paramName.setText(name);
            Element paramValue = new Element(PARAM_VALUE, this.getRootElement().getNamespace());
            paramValue.setText(value);
            contextParam.addContent("\n ");
            contextParam.addContent((Content)paramName);
            contextParam.addContent("\n ");
            contextParam.addContent((Content)paramValue);
            contextParam.addContent("\n ");
            children.add(index + 1, contextParam);
            this.writeXMLDoc();
            return;
        }
        if (append.equals((Object)INIT_PARAM.PARAM_APPEND)) {
            Element paramValue = (Element)contextParam.getChildren().get(1);
            paramValue.setText(paramValue.getText() + "," + value);
            this.writeXMLDoc();
            return;
        }
        if (append.equals((Object)INIT_PARAM.PARAM_OVERWRITE)) {
            Element paramValue = (Element)contextParam.getChildren().get(1);
            paramValue.setText(value);
            this.writeXMLDoc();
        }
    }

    public void addFilterInitParam(String filterName, String paramName, String paramValue) {
        this.addFilterInitParam(filterName, paramName, paramValue, null, INIT_PARAM.PARAM_STOP);
    }

    public void addFilterInitParam(String filterName, String name, String value, String description, INIT_PARAM append) {
        List filters = this.getRootElement().getChildren(FILTER, this.getRootElement().getNamespace());
        Element filter = this.elementLookUp(filters, FILTER_NAME, filterName);
        if (filter == null) {
            throw new IllegalStateException("The filter " + filterName + " has not been found. Have you already written the filter?");
        }
        Element initParam = this.elementLookUp(filter.getChildren(), PARAM_NAME, name);
        if (initParam != null && append.equals((Object)INIT_PARAM.PARAM_STOP)) {
            return;
        }
        if (initParam != null && append.equals((Object)INIT_PARAM.PARAM_APPEND)) {
            Element paramValue = ((Element)initParam.getParent()).getChild(PARAM_VALUE);
            paramValue.setText(paramValue.getText() + "," + value);
            this.writeXMLDoc();
            return;
        }
        if (initParam != null && append.equals((Object)INIT_PARAM.PARAM_OVERWRITE)) {
            Element paramValue = ((Element)initParam.getParent()).getChild(PARAM_VALUE);
            paramValue.setText(value);
            this.writeXMLDoc();
            return;
        }
        Element paramElement = new Element(INIT_PARAM_STR, this.getRootElement().getNamespace());
        Element param = new Element(PARAM_NAME, this.getRootElement().getNamespace());
        param.setText(name);
        paramElement.getChildren().add(param);
        param = new Element(PARAM_VALUE, this.getRootElement().getNamespace());
        param.setText(value);
        paramElement.getChildren().add(param);
        if (description != null && !description.equals("")) {
            param = new Element(DESCRIPTION, this.getRootElement().getNamespace());
            param.setText(description);
            paramElement.getChildren().add(param);
        }
        filter.getChildren().add(paramElement);
    }

    public void addInitParam(String servletName, String name, String value, String description, INIT_PARAM append) {
        Element loadOnStartUpElem;
        List servlets = this.getRootElement().getChildren(SERVLET, this.getRootElement().getNamespace());
        Element servlet = this.elementLookUp(servlets, SERVLET_NAME, servletName);
        if (servlet == null) {
            throw new IllegalStateException("The servlet " + servletName + " has not been found. Have you already written the servlet?");
        }
        Element initParam = this.elementLookUp(servlet.getChildren(), PARAM_NAME, name);
        if (initParam != null && append.equals((Object)INIT_PARAM.PARAM_STOP)) {
            return;
        }
        if (initParam != null && append.equals((Object)INIT_PARAM.PARAM_APPEND)) {
            Element paramValue = ((Element)initParam.getParent()).getChild(PARAM_VALUE);
            paramValue.setText(paramValue.getText() + "," + value);
            this.writeXMLDoc();
            return;
        }
        if (initParam != null && append.equals((Object)INIT_PARAM.PARAM_OVERWRITE)) {
            Element paramValue = ((Element)initParam.getParent()).getChild(PARAM_VALUE);
            paramValue.setText(value);
            this.writeXMLDoc();
            return;
        }
        Element paramElement = new Element(INIT_PARAM_STR, this.getRootElement().getNamespace());
        Element param = new Element(PARAM_NAME, this.getRootElement().getNamespace());
        param.setText(name);
        paramElement.getChildren().add(param);
        param = new Element(PARAM_VALUE, this.getRootElement().getNamespace());
        param.setText(value);
        paramElement.getChildren().add(param);
        if (description != null && !description.equals("")) {
            param = new Element(DESCRIPTION, this.getRootElement().getNamespace());
            param.setText(description);
            paramElement.getChildren().add(param);
        }
        if ((loadOnStartUpElem = (Element)servlet.getChildren().get(servlet.getChildren().size() - 1)).getName().equals("load-on-startup")) {
            servlet.getChildren().remove(loadOnStartUpElem);
            servlet.addContent((Content)paramElement);
            servlet.addContent((Content)loadOnStartUpElem);
        } else {
            servlet.getChildren().add(paramElement);
        }
    }

    public void addListenerInitParam(String listenerClazz, String name, String value, INIT_PARAM append) {
        List listeners = this.getRootElement().getChildren(LISTENER, this.getRootElement().getNamespace());
        Element listener = this.elementLookUp(listeners, LISTENER_CLASS, listenerClazz);
        if (listener == null) {
            throw new IllegalStateException("The listener " + listenerClazz + " has not been found. Have you already written the listener?");
        }
        Element initParam = this.elementLookUp(listener.getChildren(), PARAM_NAME, name);
        if (initParam != null && append.equals((Object)INIT_PARAM.PARAM_STOP)) {
            return;
        }
        if (initParam != null && append.equals((Object)INIT_PARAM.PARAM_APPEND)) {
            Element paramValue = ((Element)initParam.getParent()).getChild(PARAM_VALUE);
            paramValue.setText(paramValue.getText() + "," + value);
            this.writeXMLDoc();
            return;
        }
        if (initParam != null && append.equals((Object)INIT_PARAM.PARAM_OVERWRITE)) {
            Element paramValue = ((Element)initParam.getParent()).getChild(PARAM_VALUE);
            paramValue.setText(value);
            this.writeXMLDoc();
            return;
        }
        Element paramElement = new Element(INIT_PARAM_STR, this.getRootElement().getNamespace());
        Element param = new Element(PARAM_NAME, this.getRootElement().getNamespace());
        param.setText(name);
        paramElement.getChildren().add(param);
        param = new Element(PARAM_VALUE, this.getRootElement().getNamespace());
        param.setText(value);
        paramElement.getChildren().add(param);
        listener.getChildren().add(paramElement);
    }

    public void addInitParam(String servletName, String name, String value, String description) {
        this.addInitParam(servletName, name, value, description, INIT_PARAM.PARAM_STOP);
    }

    public void addServlet(String name, String clazz) {
        this.addServlet(name, clazz, -1);
    }

    public void addServlet(String name, String clazz, int loadOnStartup) {
        Element servlet = null;
        Element servletClass = null;
        List servlets = this.getRootElement().getChildren(SERVLET, this.getRootElement().getNamespace());
        servlet = this.elementLookUp(servlets, SERVLET_NAME, name);
        if (servlet != null) {
            servletClass = servlet.getChild("servlet-class", this.getRootElement().getNamespace());
            servletClass.setText(clazz);
        } else {
            Element lastServlet = (Element)servlets.get(servlets.size() - 1);
            List children = this.getRootElement().getChildren();
            int index = children.indexOf(lastServlet);
            servlet = new Element(SERVLET, this.getRootElement().getNamespace());
            Element servletNameElement = new Element(SERVLET_NAME, this.getRootElement().getNamespace());
            servletNameElement.setText(name);
            servletClass = new Element("servlet-class", this.getRootElement().getNamespace());
            servletClass.setText(clazz);
            servlet.addContent("\n ");
            servlet.addContent((Content)servletNameElement);
            servlet.addContent("\n ");
            servlet.addContent((Content)servletClass);
            servlet.addContent("\n ");
            children.add(index + 1, servlet);
        }
        this.writeXMLDoc();
    }

    public void addFilter(String name, String clazz) {
        Element filter = null;
        Element filterClass = null;
        List filters = this.getRootElement().getChildren(FILTER, this.getRootElement().getNamespace());
        filter = this.elementLookUp(filters, FILTER_NAME, name);
        if (filter != null) {
            filterClass = filter.getChild("filter-class", this.getRootElement().getNamespace());
            filterClass.setText(clazz);
        } else {
            Element lastFilter = (Element)filters.get(filters.size() - 1);
            List children = this.getRootElement().getChildren();
            int index = children.indexOf(lastFilter);
            filter = new Element(FILTER, this.getRootElement().getNamespace());
            Element filterNameElement = new Element(FILTER_NAME, this.getRootElement().getNamespace());
            filterNameElement.setText(name);
            filterClass = new Element("filter-class", this.getRootElement().getNamespace());
            filterClass.setText(clazz);
            filter.addContent("\n ");
            filter.addContent((Content)filterNameElement);
            filter.addContent("\n ");
            filter.addContent((Content)filterClass);
            filter.addContent("\n ");
            children.add(index + 1, filter);
        }
        this.writeXMLDoc();
    }

    public void addListener(String clazz) {
        Element listener = null;
        Element listenerClass = null;
        List listeners = this.getRootElement().getChildren(LISTENER, this.getRootElement().getNamespace());
        listener = this.elementLookUp(listeners, LISTENER_CLASS, clazz);
        if (listener == null) {
            Element lastListener = (Element)listeners.get(listeners.size() - 1);
            List children = this.getRootElement().getChildren();
            int index = children.indexOf(lastListener);
            listener = new Element(LISTENER, this.getRootElement().getNamespace());
            listenerClass = new Element(LISTENER_CLASS, this.getRootElement().getNamespace());
            listenerClass.setText(clazz);
            listener.addContent("\n ");
            listener.addContent((Content)listenerClass);
            listener.addContent("\n ");
            children.add(index + 1, listener);
        }
        this.writeXMLDoc();
    }

    public void addServletMapping(String servlet, String pattern) {
        List mappings = this.getRootElement().getChildren("servlet-mapping", this.getRootElement().getNamespace());
        for (Element elem : mappings) {
            Element servletName = elem.getChild(SERVLET_NAME, elem.getNamespace());
            Element urlPattern = elem.getChild(URL_PATTERN, elem.getNamespace());
            if (!servletName.getText().trim().equals(servlet) || !urlPattern.getText().trim().equals(pattern)) continue;
            return;
        }
        Element lastMapping = (Element)mappings.get(mappings.size() - 1);
        List children = this.getRootElement().getChildren();
        int index = children.indexOf(lastMapping);
        Element servletMapping = new Element("servlet-mapping", this.getRootElement().getNamespace());
        Element servletName = new Element(SERVLET_NAME, this.getRootElement().getNamespace());
        servletName.setText(servlet);
        Element servletPattern = new Element(URL_PATTERN, this.getRootElement().getNamespace());
        servletPattern.setText(pattern);
        servletMapping.addContent("\n ");
        servletMapping.addContent((Content)servletName);
        servletMapping.addContent("\n ");
        servletMapping.addContent((Content)servletPattern);
        servletMapping.addContent("\n ");
        children.add(index + 1, servletMapping);
        this.writeXMLDoc();
    }

    public void addFilterMapping(String filter, String pattern) {
        List mappings = this.getRootElement().getChildren("filter-mapping", this.getRootElement().getNamespace());
        for (Element elem : mappings) {
            Element filterName = elem.getChild(FILTER_NAME, elem.getNamespace());
            Element urlPattern = elem.getChild(URL_PATTERN, elem.getNamespace());
            if (!filterName.getText().trim().equals(filter) || !urlPattern.getText().trim().equals(pattern)) continue;
            return;
        }
        Element lastMapping = (Element)mappings.get(mappings.size() - 1);
        List children = this.getRootElement().getChildren();
        int index = children.indexOf(lastMapping);
        Element filterMapping = new Element("filter-mapping", this.getRootElement().getNamespace());
        Element filterName = new Element(FILTER_NAME, this.getRootElement().getNamespace());
        filterName.setText(filter);
        Element filterPattern = new Element(URL_PATTERN, this.getRootElement().getNamespace());
        filterPattern.setText(pattern);
        filterMapping.addContent("\n ");
        filterMapping.addContent((Content)filterName);
        filterMapping.addContent("\n ");
        filterMapping.addContent((Content)filterPattern);
        filterMapping.addContent("\n ");
        children.add(index + 1, filterMapping);
        this.writeXMLDoc();
    }

    public void setDisplayName(String displayName) {
        Element element = this.getRootElement().getChild("display-name", this.getRootElement().getNamespace());
        element.setText(displayName);
        this.writeXMLDoc();
    }

    public String getDisplayName() {
        Element element = this.getRootElement().getChild("display-name", this.getRootElement().getNamespace());
        return element.getText();
    }

    public void setDescription(String description) {
        Element element = this.getRootElement().getChild(DESCRIPTION, this.getRootElement().getNamespace());
        element.setText(description);
        this.writeXMLDoc();
    }

    public boolean setTransportGuarantee(String policy) {
        boolean modified = false;
        Namespace namespace = this.getRootElement().getNamespace();
        List constraints = this.getRootElement().getChildren("security-constraint", namespace);
        for (Element constraint : constraints) {
            Element transport;
            Element userData = constraint.getChild("user-data-constraint", namespace);
            if (userData == null || (transport = userData.getChild("transport-guarantee", namespace)) == null || transport.getText().equals(policy)) continue;
            transport.setText(policy);
            modified = true;
        }
        if (modified) {
            this.writeXMLDoc();
        }
        return modified;
    }

    public static enum INIT_PARAM {
        PARAM_OVERWRITE,
        PARAM_APPEND,
        PARAM_STOP;

    }
}

