/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.config;

import com.logicaldoc.util.config.ContextProperties;
import com.logicaldoc.util.config.XMLBean;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.text.StrSubstitutor;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.jdom2.CDATA;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogConfigurator {
    private static final String LEVEL = "level";
    private static final String LOGGERS = "//Loggers";
    private static final String ROOT = "${root}/";
    private static final String FILE_NAME = "fileName";
    private static final String ROLLING_FILE_NAME = "//RollingFile[@name='";
    private static final String APPENDERS = "//Appenders";
    private XMLBean xml;

    public LogConfigurator() {
        URL configFile = null;
        try {
            configFile = LogConfigurator.class.getClassLoader().getResource("/log.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configFile == null) {
            configFile = LogConfigurator.class.getClassLoader().getResource("log.xml");
        }
        this.xml = new XMLBean(configFile);
    }

    public String getProperty(String name) {
        Element elem = this.xml.findElement("//Property[@name='" + name + "']");
        if (elem != null) {
            return elem.getTextTrim();
        }
        return null;
    }

    public Collection<String> getAppenders() {
        Element appenders = this.xml.findElement(APPENDERS);
        List children = appenders.getChildren();
        return children.stream().map(c -> c.getAttributeValue("name")).toList();
    }

    public Element getAppender(String name) {
        Element appenders = this.xml.findElement(APPENDERS);
        return appenders.getChildren().stream().filter(c -> name.equals(c.getAttributeValue("name"))).findFirst().orElse(null);
    }

    public Element getLogger(String name) {
        return this.getLoggers().stream().filter(c -> name.equals(c.getAttributeValue("name"))).findFirst().orElse(null);
    }

    public Collection<Element> getLoggers() {
        Element loggers = this.xml.findElement(LOGGERS);
        return loggers.getChildren();
    }

    public String getFile(String appender) {
        return this.getFile(appender, true);
    }

    public String getFile(String appender, boolean replaceVariables) {
        String result = null;
        Element elem = this.xml.findElement(ROLLING_FILE_NAME + appender + "']");
        if (elem != null) {
            result = elem.getAttributeValue(FILE_NAME);
            if (result.contains("${root}")) {
                result = result.replace("${root}", this.getProperty("root"));
            }
            if (replaceVariables) {
                result = StrSubstitutor.replaceSystemProperties(result);
            }
        }
        return result;
    }

    public void addTextAppender(String name) {
        this.addTextAppender(name, false, null);
    }

    public void addTextAppender(String name, boolean immediateFlush, String pattern) {
        if (this.xml.findElement(ROLLING_FILE_NAME + name + "']") != null) {
            return;
        }
        Element model = this.xml.findElement("//RollingFile[@name='DMS']");
        Element newAppender = model.clone();
        Element appenders = this.xml.findElement(APPENDERS);
        appenders.addContent(0, (Content)newAppender);
        if (StringUtils.isNotEmpty(pattern)) {
            List patternLayouts = newAppender.getChildren("PatternLayout");
            for (Element patternLayout : patternLayouts) {
                Element patternElement = patternLayout.getChild("Pattern");
                if (patternElement == null) continue;
                patternElement.setText(pattern);
            }
        }
        newAppender.setAttribute("name", name);
        if (immediateFlush) {
            newAppender.setAttribute("immediateFlush", "true");
        }
        String logfile = name.trim().toLowerCase() + ".log";
        newAppender.setAttribute(FILE_NAME, ROOT + logfile);
        newAppender.setAttribute("filePattern", ROOT + logfile + ".%i");
    }

    public void addHtmlAppender(String name) {
        if (this.xml.findElement(ROLLING_FILE_NAME + name + "']") != null) {
            return;
        }
        Element model = this.xml.findElement("//RollingFile[@name='DMS_WEB']");
        Element newAppender = model.clone();
        Element appenders = this.xml.findElement(APPENDERS);
        appenders.addContent(0, (Content)newAppender);
        newAppender.setAttribute("name", name);
        String logfile = name.trim().toLowerCase() + ".log.html";
        newAppender.setAttribute(FILE_NAME, ROOT + logfile);
        newAppender.setAttribute("filePattern", ROOT + logfile + ".%i");
    }

    public void addLogger(String name, List<String> appenders) {
        this.setLogger(name, false, "info", appenders);
    }

    public void setLogger(String name, boolean additivity, String level, List<String> appenders) {
        this.setLogger(name, additivity, level, appenders, null);
    }

    public void setLogger(String name, boolean additivity, String level, List<String> appenders, List<String> appenderLevels) {
        Element logger = this.xml.findElement("//Logger[@name='" + name + "']");
        if (logger == null) {
            logger = new Element("Logger");
            logger.setAttribute("name", name);
            Element loggers = this.xml.findElement(LOGGERS);
            loggers.addContent(0, (Content)logger);
        }
        logger.setAttribute("additivity", Boolean.toString(additivity));
        logger.setAttribute(LEVEL, level);
        if (appenders != null && !appenders.isEmpty()) {
            logger.removeContent();
            for (String app : appenders) {
                Element appender = new Element("AppenderRef");
                appender.setAttribute("ref", app);
                if (appenderLevels != null && !appenderLevels.isEmpty()) {
                    appender.setAttribute(LEVEL, appenderLevels.get(appenders.indexOf(app)));
                }
                logger.addContent((Content)appender);
            }
        }
    }

    public void removeLogger(String name) {
        Element logger = this.xml.findElement("//Logger[@name='" + name + "']");
        if (logger != null) {
            Element loggers = this.xml.findElement(LOGGERS);
            loggers.removeContent((Content)logger);
        }
    }

    public String getRootLevel() {
        return this.xml.findElement("//Root").getAttributeValue(LEVEL);
    }

    public void setRootLevel(String level) {
        this.xml.findElement("//Root").setAttribute(LEVEL, level);
    }

    public void setLogsRoot(String rootPath) {
        Element elem = this.xml.findElement("//Property[@name='root']");
        if (elem != null) {
            elem.setContent((Content)new CDATA(rootPath.trim()));
        }
    }

    public String getLogsRoot() {
        return this.getProperty("root");
    }

    public boolean write() {
        return this.xml.writeXMLDoc();
    }

    public void initializeLogging() {
        Logger log = LoggerFactory.getLogger("console");
        String log4jPath = null;
        try {
            log4jPath = this.getLogConfigFilePath();
            ContextProperties config = new ContextProperties();
            LogConfigurator lconf = new LogConfigurator();
            lconf.setLogsRoot(config.getProperty("conf.logdir"));
            lconf.write();
            log.info("Initializing the logging taking configuration from {}", (Object)log4jPath);
            LoggerContext lContext = Configurator.initialize(null, log4jPath);
            if (lContext == null) {
                throw new IOException("Null logger context");
            }
        }
        catch (Exception e) {
            log.error("Cannot initialize the log: {}", (Object)e.getMessage());
        }
    }

    private String getLogConfigFilePath() throws UnsupportedEncodingException {
        URL configFile = null;
        try {
            configFile = LogConfigurator.class.getClassLoader().getResource("/log.xml");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (configFile == null) {
            configFile = LogConfigurator.class.getClassLoader().getResource("log.xml");
        }
        String log4jPath = URLDecoder.decode(configFile.getPath(), "UTF-8");
        return log4jPath;
    }
}

