/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.config;

import com.logicaldoc.util.config.XMLBean;
import java.util.LinkedList;
import java.util.List;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;

public class ContextConfigurator {
    private static final String PROPERTY = "property";
    protected XMLBean xml;

    public ContextConfigurator(String resource) {
        this.xml = this.getClass().getClassLoader().getResource(resource) != null ? new XMLBean(this.getClass().getClassLoader().getResource(resource)) : new XMLBean(resource);
    }

    public ContextConfigurator() {
        this.xml = new XMLBean(this.getClass().getClassLoader().getResource("context.xml"));
    }

    public void setProperty(String id, String propertyName, String value) {
        Element element = this.xml.getChild("bean", "id", id);
        for (Element property : element.getChildren(PROPERTY, element.getNamespace())) {
            if (!propertyName.equals(property.getAttribute("name").getValue())) continue;
            property.getChild("value").setText(value);
            break;
        }
    }

    public void clearPropertyValue(String id, String propertyName) {
        Element element = this.xml.getChild("bean", "id", id);
        if (element == null) {
            return;
        }
        for (Element property : element.getChildren(PROPERTY, element.getNamespace())) {
            if (!propertyName.equals(property.getAttribute("name").getValue())) continue;
            property.removeContent();
            return;
        }
    }

    public void addPropertyBeanRefList(String id, String propertyName, List<String> values) {
        Element element = this.xml.getChild("bean", "id", id);
        if (element == null) {
            return;
        }
        for (Element property : element.getChildren(PROPERTY, element.getNamespace())) {
            if (!propertyName.equals(property.getAttribute("name").getValue())) continue;
            this.addPropertyListValues(property, values);
            break;
        }
    }

    private void addPropertyListValues(Element property, List<String> values) {
        LinkedList<Element> beanRefChildren = new LinkedList<Element>();
        Element listElement = property.getChild("list", property.getNamespace());
        if (listElement != null) {
            List elms = listElement.getChildren();
            for (Element elm : elms) {
                if (!elm.getName().equals("ref")) continue;
                beanRefChildren.add(elm);
            }
        } else {
            listElement = new Element("list");
        }
        for (String value : values) {
            Element refBeanElement = new Element("ref");
            refBeanElement.setAttribute(new Attribute("bean", value));
            beanRefChildren.add(refBeanElement);
        }
        listElement.removeContent();
        listElement.setContent(beanRefChildren);
        property.setContent((Content)listElement);
    }

    public String getProperty(String id, String propertyName) {
        Element element = this.getPropertyElement(id, propertyName);
        if (element != null) {
            return element.getChild("value").getText();
        }
        return null;
    }

    public String getPropertyProp(String id, String propertyName, String key) {
        Element element = this.getPropElement(id, propertyName, key);
        if (element != null) {
            return element.getText();
        }
        return null;
    }

    protected Element getPropElement(String id, String propertyName, String key) {
        Element element = this.getPropertyElement(id, propertyName);
        Element props = element.getChild("props", element.getNamespace());
        for (Element prop : props.getChildren()) {
            if (!key.equals(prop.getAttributeValue("key"))) continue;
            return prop;
        }
        return null;
    }

    public void setPropValue(String id, String propertyName, String key, String value) {
        Element prop = this.getPropElement(id, propertyName, key);
        if (prop != null) {
            prop.setText(value);
        }
    }

    protected Element getPropertyElement(String id, String propertyName) {
        Element element = this.xml.getChild("bean", "id", id);
        if (element == null) {
            return null;
        }
        List properties = element.getChildren(PROPERTY, element.getNamespace());
        for (Element property : properties) {
            Attribute nameAttribute = property.getAttribute("name");
            if (nameAttribute == null || !propertyName.equals(nameAttribute.getValue())) continue;
            return property;
        }
        return null;
    }

    public String getDialect() {
        return this.getPropertyProp("SessionFactory", "hibernateProperties", "hibernate.dialect");
    }

    public boolean write() {
        return this.xml.writeXMLDoc();
    }

    public void addTrigger(String triggerId) {
        Element ref2;
        Element element = this.getPropertyElement("Scheduler", "triggers");
        Element list = element.getChild("list", element.getNamespace());
        List refs = list.getChildren("ref", element.getNamespace());
        for (Element ref2 : refs) {
            if (!triggerId.equals(ref2.getAttribute("bean").getValue())) continue;
            return;
        }
        ref2 = new Element("ref", element.getNamespace());
        ref2.setAttribute("bean", triggerId);
        list.addContent((Content)ref2);
        this.xml.writeXMLDoc();
    }
}

