/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.concurrent;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class LaxSerialFuture<V>
implements Future<V> {
    private List<Future<? extends V>> futures = new ArrayList<Future<? extends V>>();

    public LaxSerialFuture(Collection<Future<? extends V>> futures) {
        for (Future<V> future : futures) {
            this.futures.add(future);
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.futures.stream().allMatch(f -> f.cancel(mayInterruptIfRunning));
    }

    @Override
    public boolean isCancelled() {
        return this.futures.stream().allMatch(Future::isCancelled);
    }

    @Override
    public boolean isDone() {
        return this.futures.stream().allMatch(Future::isDone);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.getAll().stream().findFirst().orElse(null);
    }

    public List<V> getAll() throws InterruptedException, ExecutionException {
        ArrayList<V> gets = new ArrayList<V>();
        for (Future<V> future : this.futures) {
            gets.add(future.get());
        }
        return gets;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.getAll(timeout, unit).stream().findFirst().orElse(null);
    }

    public List<V> getAll(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        ArrayList<V> gets = new ArrayList<V>();
        for (Future<V> future : this.futures) {
            gets.add(future.get(timeout, unit));
        }
        return gets;
    }
}

