/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util.cache;

import com.logicaldoc.util.cache.Cache;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collection;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCache<K extends Serializable, V>
implements Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(EhCache.class);
    private net.sf.ehcache.Cache cache;
    private static CacheManager manager;

    public EhCache(net.sf.ehcache.Cache cache) {
        this.cache = cache;
    }

    @Override
    public boolean contains(K key) {
        try {
            return this.cache.get(key) != null;
        }
        catch (CacheException e) {
            throw new CacheException("contains failed", (Throwable)e);
        }
    }

    @Override
    public Collection<K> getKeys() {
        return this.cache.getKeys();
    }

    @Override
    public V get(K key) {
        block3: {
            try {
                Element element = this.cache.get(key);
                if (element == null) break block3;
                return (V)element.getObjectValue();
            }
            catch (IllegalStateException ie) {
                throw new CacheException("Failed to get from EhCache as state invalid: \n  state: " + String.valueOf(this.cache.getStatus()) + "\n   key: " + String.valueOf(key), (Throwable)ie);
            }
            catch (CacheException e) {
                throw new CacheException("Failed to get from EhCache: \n   key: " + String.valueOf(key), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void put(K key, V value) {
        Element element = new Element(key, value);
        this.cache.put(element);
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public void clear() {
        this.cache.removeAll();
    }

    @Override
    public void flush() {
        this.cache.flush();
    }

    @Override
    public long getSize() {
        return this.cache.getSize();
    }

    public static final synchronized void reloadManager() {
        if (manager != null) {
            manager.shutdown();
        }
        EhCache.getManager();
    }

    public static final synchronized CacheManager getManager() {
        if (manager == null) {
            try {
                System.setProperty("net.sf.ehcache.enableShutdownHook", "TRUE");
                URL resource = net.sf.ehcache.Cache.class.getResource("/cache.xml");
                manager = CacheManager.create((String)Paths.get(resource.toURI()).toFile().getAbsolutePath());
            }
            catch (Exception e) {
                log.error("Cannot initialize the cache manager");
                return null;
            }
        }
        return manager;
    }
}

