/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.Map;

public class SystemUtil {
    private SystemUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String printEnvironment() {
        StringBuilder sb = new StringBuilder();
        sb.append(SystemUtil.printSystemEnvironment());
        sb.append("\n\n");
        sb.append(SystemUtil.printJavaEnvironment());
        return sb.toString();
    }

    public static String printStackTrace() {
        StackTraceElement[] elements;
        StringBuilder sb = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = elements = Thread.currentThread().getStackTrace();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement element = stackTraceElementArray[n2];
            if (!(element.getClassName().equals(Thread.class.getName()) && element.getMethodName().equals("getStackTrace") || element.getClassName().equals(SystemUtil.class.getName()) && element.getMethodName().equals("printStackTrace"))) {
                sb.append(element.getClassName());
                sb.append(".");
                sb.append(element.getMethodName());
                sb.append("(");
                sb.append(element.getLineNumber());
                sb.append(")\n");
            }
            ++n2;
        }
        return sb.toString();
    }

    public static String printSystemEnvironment() {
        StringBuilder sb = new StringBuilder();
        Map<String, String> env = System.getenv();
        for (Map.Entry<String, String> entry : env.entrySet()) {
            if (sb.length() > 0) {
                sb.append("\n");
            }
            sb.append(entry.getKey());
            sb.append("=");
            sb.append(entry.getValue());
        }
        return "#System Environment\n#" + String.valueOf(new Date()) + "\n" + sb.toString();
    }

    public static String printJavaEnvironment() {
        StringWriter writer = new StringWriter();
        try {
            System.getProperties().store(new PrintWriter(writer), "Java Environment");
            return writer.getBuffer().toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }

    public static boolean isWindows() {
        return SystemUtil.osName().contains("windows");
    }

    private static String osName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static boolean isMac() {
        return SystemUtil.osName().contains("mac");
    }

    public static boolean isUnix() {
        return SystemUtil.osName().contains("nix") || SystemUtil.osName().contains("nux") || SystemUtil.osName().contains("aix");
    }

    public static boolean isSolaris() {
        return SystemUtil.osName().contains("sunos");
    }

    public static String getOS() {
        if (SystemUtil.isWindows()) {
            return "win";
        }
        if (SystemUtil.isMac()) {
            return "osx";
        }
        if (SystemUtil.isUnix()) {
            return "uni";
        }
        if (SystemUtil.isSolaris()) {
            return "sol";
        }
        return "err";
    }
}

