/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.util;

import com.logicaldoc.util.io.FileUtil;
import com.logicaldoc.util.io.ResourceUtil;
import java.io.IOException;
import java.util.Properties;

public class MimeType {
    private static Properties mimeTypes = null;

    private MimeType() {
        throw new IllegalStateException("Utility class");
    }

    public static String get(String extension) {
        String type;
        if (mimeTypes == null) {
            mimeTypes = new Properties();
            try {
                mimeTypes.load(ResourceUtil.getInputStream("mimetypes.properties"));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        if ((type = mimeTypes.getProperty(extension, "application/octet-stream")) == null) {
            type = "application/octet-stream";
        }
        return type;
    }

    public static String getByFilename(String filename) {
        return MimeType.get(FileUtil.getExtension(filename));
    }
}

