/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.webstart;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.data.Pack;
import com.izforge.izpack.api.data.Variables;
import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.resource.Resources;
import com.izforge.izpack.api.rules.RulesEngine;
import com.izforge.izpack.api.substitutor.VariableSubstitutor;
import com.izforge.izpack.core.os.RegistryDefaultHandler;
import com.izforge.izpack.event.RegistryInstallerListener;
import com.izforge.izpack.installer.data.UninstallData;
import com.izforge.izpack.installer.unpacker.IUnpacker;
import com.izforge.izpack.util.Housekeeper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.List;

public class LDRegistryInstallerListener
extends RegistryInstallerListener {
    public LDRegistryInstallerListener(IUnpacker unpacker, VariableSubstitutor substituter, InstallData installData, UninstallData uninstallData, Resources resources, RulesEngine rules, Housekeeper housekeeper, RegistryDefaultHandler handler) {
        super(unpacker, substituter, installData, uninstallData, resources, rules, housekeeper, handler);
    }

    @Override
    protected String getUninstallName() {
        Variables variables = this.getInstallData().getVariables();
        return variables.get("APP_NAME");
    }

    @Override
    public void afterPacks(List<Pack> arg0, ProgressListener arg1) {
        try {
            Variables variables = this.getInstallData().getVariables();
            String intallPath = variables.get("INSTALL_PATH");
            String batFile = intallPath + "\\webstart.bat";
            LDRegistryInstallerListener.replaceInFile(batFile, "JREHOME", System.getProperty("java.home"));
            String regFile = intallPath + "\\resources\\webstart.reg";
            LDRegistryInstallerListener.replaceInFile(regFile, "INSTALL_PATH", intallPath.replace("\\", "\\\\").replace("/", "\\\\"));
            Process process = Runtime.getRuntime().exec("reg IMPORT \"" + regFile + "\"");
            process.waitFor();
        }
        catch (IndexOutOfBoundsException variables) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void replaceInFile(String sourcePath, String token, String newValue) throws Exception {
        String oldContent = "";
        File tmp = new File(sourcePath + ".tmp");
        File file = new File(sourcePath);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourcePath), "UTF-8"));
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), "UTF-8");){
            String line = reader.readLine();
            while (line != null) {
                oldContent = oldContent + line + System.lineSeparator();
                line = reader.readLine();
            }
            String newContent = oldContent.replace(token, newValue);
            writer.write(newContent);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        file.delete();
        tmp.renameTo(file);
    }
}

