/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.util;

import java.io.PrintWriter;
import java.util.Date;

public class Log {
    private static PrintWriter fw = null;

    public static void warn(String message, Throwable t) {
        if (fw == null) {
            return;
        }
        try {
            String txt = String.format("%tc - WARN - %s", new Date(), message != null ? message : "");
            System.out.println(txt);
            fw.write(txt);
            fw.write("\n");
            if (t != null) {
                t.printStackTrace(fw);
                fw.write("\n");
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), null);
        }
        finally {
            try {
                fw.flush();
            }
            catch (Exception exception) {}
        }
    }

    public static void info(String message, Throwable t) {
        if (fw == null) {
            return;
        }
        try {
            String txt = String.format("%tc - INFO - %s", new Date(), message != null ? message : "");
            System.out.println(txt);
            fw.write(txt);
            fw.write("\n");
            if (t != null) {
                t.printStackTrace(fw);
                fw.write("\n");
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), null);
        }
        finally {
            try {
                fw.flush();
            }
            catch (Exception exception) {}
        }
    }

    public static void error(String message, Throwable t) {
        if (fw == null) {
            return;
        }
        try {
            String txt = String.format("%tc - ERROR - %s", new Date(), message != null ? message : "");
            System.out.println(txt);
            fw.write(txt);
            fw.write("\n");
            if (t != null) {
                t.printStackTrace(fw);
                fw.write("\n");
            }
        }
        catch (Exception e) {
            fw.write(String.format("%tc - ERROR - %s", new Date(), e.getMessage()));
            fw.write("\n");
            if (e != null) {
                e.printStackTrace(fw);
                fw.write("\n");
            }
        }
        finally {
            try {
                fw.flush();
            }
            catch (Exception exception) {}
        }
    }

    public void dispose() throws Throwable {
        fw.close();
    }

    static {
        try {
            fw = new PrintWriter("install.log");
            Log.info("Setup BEGINS", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            fw = null;
        }
    }
}

