/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.util;

import com.logicaldoc.installer.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

public class Exec {
    public static int exec(List<String> command) throws IOException {
        return Exec.exec(command, null, null, -1);
    }

    public static int exec(final List<String> command, Map<String, String> env, File dir, int timeout) throws IOException {
        int exit = 0;
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectErrorStream(true);
        if (env != null) {
            for (String name : env.keySet()) {
                builder.environment().put(name, env.get(name).toString());
            }
        }
        if (dir != null) {
            builder.directory(dir);
        }
        final Process process = builder.start();
        Timer t = null;
        if (timeout > 0) {
            t = new Timer(true);
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    Log.info("Timeout command " + (String)command.get(0), null);
                    process.destroy();
                }
            }, timeout * 1000);
        }
        StreamEater errEater = new StreamEater("err", process.getErrorStream());
        StreamEater outEater = new StreamEater("out", process.getInputStream());
        Thread a = new Thread(errEater);
        a.start();
        Thread b = new Thread(outEater);
        b.start();
        try {
            exit = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (t != null) {
            t.cancel();
        }
        process.destroy();
        return exit;
    }

    public static int exec(final String commandLine, String[] env, File dir, int timeout) throws IOException {
        int exit = 0;
        Runtime runtime = Runtime.getRuntime();
        final Process process = runtime.exec(commandLine, env, dir);
        Timer t = null;
        if (timeout > 0) {
            t = new Timer(true);
            t.schedule(new TimerTask(){

                @Override
                public void run() {
                    Log.info("Timeout command " + commandLine, null);
                    process.destroy();
                }
            }, timeout * 1000);
        }
        StreamEater errEater = new StreamEater("err", process.getErrorStream());
        StreamEater outEater = new StreamEater("out", process.getInputStream());
        Thread a = new Thread(errEater);
        a.start();
        Thread b = new Thread(outEater);
        b.start();
        try {
            exit = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return exit;
    }

    static class StreamEater
    implements Runnable {
        private InputStream stream;
        private String prefix;

        public StreamEater(String prefix, InputStream stream) {
            this.prefix = prefix;
            this.stream = stream;
        }

        @Override
        public void run() {
            try {
                InputStreamReader isr = new InputStreamReader(this.stream);
                BufferedReader br = new BufferedReader(isr);
                String line = br.readLine();
                while (line != null) {
                    Log.info(this.prefix + ":" + line, null);
                    line = br.readLine();
                }
                br.close();
            }
            catch (IOException e) {
                Log.error(e.getMessage(), e);
            }
        }
    }
}

