/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.update;

import com.logicaldoc.installer.update.Log;
import com.logicaldoc.installer.util.Exec;
import com.logicaldoc.installer.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class UpdateWatchDog {
    private WatchService watcher;
    private File ldocInstallDir = UpdateWatchDog.getWatchDogDir().getParentFile();
    private File updatesDir;
    private File patchesDir;
    private boolean trace = true;
    private static UpdateWatchDog instance;
    private static File pidFile;

    public static UpdateWatchDog get() throws IOException {
        if (instance == null) {
            instance = new UpdateWatchDog();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block11: {
            pidFile = new File(UpdateWatchDog.getWatchDogDir(), "pid");
            try {
                if (args == null || args.length == 0) {
                    UpdateWatchDog.get().start();
                }
                if ("start".equals(args[0])) {
                    UpdateWatchDog.get().start();
                    break block11;
                }
                if ("stop".equals(args[0])) {
                    UpdateWatchDog.get().stop();
                    break block11;
                }
                if (!"restart".equals(args[0])) break block11;
                UpdateWatchDog.get().stop();
                while (pidFile.exists()) {
                    File file = pidFile;
                    synchronized (file) {
                        try {
                            pidFile.wait(2000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                UpdateWatchDog.get().start();
            }
            catch (Exception e) {
                Log.error(e.getMessage(), e);
            }
        }
    }

    public static File getWatchDogDir() {
        File wdDir = new File(System.getProperty("user.dir"));
        try {
            File jarFile = new File(UpdateWatchDog.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            wdDir = jarFile.getParentFile().getParentFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wdDir;
    }

    private UpdateWatchDog() {
        Log.info("LogicalDOC installed in path " + this.ldocInstallDir.getAbsolutePath(), null);
        this.updatesDir = new File(this.ldocInstallDir, "updates");
        this.patchesDir = new File(this.ldocInstallDir, "patches");
        Log.info("Watching updates folder " + this.updatesDir.getAbsolutePath(), null);
        Log.info("Watching patches folder " + this.patchesDir.getAbsolutePath(), null);
    }

    public void start() throws Exception {
        this.writePid();
        Thread whatchdog = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (pidFile.exists()) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        try {
                            this.wait(1000L);
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                    }
                }
                UpdateWatchDog.this.trace = false;
                try {
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Log.info("Exiting", null);
                System.exit(0);
            }
        };
        whatchdog.start();
        Log.info("Update Watch Dog started", null);
        this.processEvents();
    }

    public void stop() throws Exception {
        Log.info("Stopping", null);
        pidFile.delete();
        this.trace = false;
        if (pidFile.exists()) {
            FileUtils.forceDelete(pidFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processEvents() throws IOException {
        this.watcher = FileSystems.getDefault().newWatchService();
        this.updatesDir.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        this.patchesDir.toPath().register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY);
        Log.info("Listen for events", null);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        block17: while (this.trace) {
            WatchKey key = null;
            try {
                key = this.watcher.take();
            }
            catch (InterruptedException x) {
                continue;
            }
            for (WatchEvent<?> event : key.pollEvents()) {
                if (!this.trace) continue block17;
                try {
                    File command;
                    String message;
                    Object now;
                    WatchEvent.Kind<?> kind = event.kind();
                    WatchEvent<?> ev = event;
                    Path name = (Path)ev.context();
                    File file = name.toFile();
                    long size = file.length();
                    if (file.getName().startsWith("ldoc_upd-") && file.getName().endsWith(".zip")) {
                        Log.info("Detected update package " + file.getName(), null);
                        while (file.length() != size) {
                            size = file.length();
                            UpdateWatchDog updateWatchDog = this;
                            synchronized (updateWatchDog) {
                                try {
                                    this.wait(1000L);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        now = new Date();
                        message = String.format("%s - %s: %s", df.format((Date)now), kind.name(), file.getName());
                        Log.info(message, null);
                        Log.info("Launch the update", null);
                        command = new File(this.ldocInstallDir.getAbsolutePath() + "/bin/update");
                        command = FileUtil.isWindows() ? new File(command.getAbsolutePath() + ".bat") : new File(command.getAbsolutePath() + ".sh");
                        Exec.exec(command.getAbsolutePath(), null, this.updatesDir, -1);
                        continue;
                    }
                    if (file.getName().startsWith("ldoc_patch-") && file.getName().endsWith(".zip")) {
                        Log.info("Detected patch " + file.getName(), null);
                        while (file.length() != size) {
                            size = file.length();
                            now = this;
                            synchronized (now) {
                                try {
                                    this.wait(1000L);
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                        }
                        now = new Date();
                        message = String.format("%s - %s: %s", df.format((Date)now), kind.name(), file.getName());
                        Log.info(message, null);
                        Log.info("Launch the patch", null);
                        command = new File(this.ldocInstallDir.getAbsolutePath() + "/bin/patch");
                        command = FileUtil.isWindows() ? new File(command.getAbsolutePath() + ".bat") : new File(command.getAbsolutePath() + ".sh");
                        Exec.exec(command.getAbsolutePath(), null, this.updatesDir, -1);
                        continue;
                    }
                    if (!file.getName().equals("restart")) continue;
                    Log.info("Detected restart request", null);
                    File command2 = new File(this.ldocInstallDir.getAbsolutePath() + "/bin/restart");
                    command2 = FileUtil.isWindows() ? new File(command2.getAbsolutePath() + ".bat") : new File(command2.getAbsolutePath() + ".sh");
                    Log.info("Invoking command " + command2, null);
                    Exec.exec(command2.getAbsolutePath(), null, new File(this.ldocInstallDir, "bin"), -1);
                    FileUtils.deleteQuietly(file);
                }
                catch (Exception t) {
                    Log.error(t.getMessage(), t);
                }
                finally {
                    if (key == null) continue;
                    key.reset();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String writePid() {
        pidFile = new File(UpdateWatchDog.getWatchDogDir(), "pid");
        OutputStreamWriter fw = null;
        String pid = null;
        try {
            pid = ManagementFactory.getRuntimeMXBean().getName();
            pid = pid.substring(0, pid.indexOf("@"));
            fw = new FileWriter(pidFile, false);
            fw.write(pid);
            fw.flush();
        }
        catch (Exception exception) {
        }
        finally {
            try {
                fw.close();
            }
            catch (IOException iOException) {}
        }
        return pid;
    }

    static {
        pidFile = null;
    }
}

