/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.update;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;

public class ReplicateTenantProperties {
    public static void main(String[] args) throws IOException {
        ReplicateTenantProperties.replicateProperties(args[0], args[1]);
    }

    public static void replicateProperties(String contextFile, String tenantsFile) throws FileNotFoundException, IOException {
        String line;
        ArrayList<String> tenants = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new FileReader(tenantsFile));
        while ((line = br.readLine()) != null) {
            String tenant;
            if (line == null || line.isEmpty() || "default".equals(tenant = line.trim()) || tenant.contains("ld_name") || tenant.contains(" ")) continue;
            tenants.add(tenant);
        }
        br.close();
        if (!tenants.isEmpty()) {
            System.out.println("Detected tenants " + tenants);
            ReplicateTenantProperties.replicateProperties(new File(contextFile), tenants);
        }
    }

    public static void replicateProperties(File contextFile, Collection<String> tenants) throws FileNotFoundException, IOException {
        Properties prop = new Properties();
        prop.load(new FileReader(contextFile));
        HashMap<String, String> params = new HashMap<String, String>();
        Set<Object> keys = prop.keySet();
        for (Object key : keys) {
            String keyString = key.toString();
            if (!keyString.startsWith("default.")) continue;
            String baseName = keyString.substring("default.".length());
            params.put(baseName, prop.getProperty(keyString));
        }
        for (String tenant : tenants) {
            if ("default".equals(tenant)) continue;
            for (String param : params.keySet()) {
                String tenantParam = tenant + "." + param;
                if (prop.containsKey(tenantParam)) continue;
                prop.setProperty(tenantParam, (String)params.get(param));
            }
            ReplicateTenantProperties.write(prop, contextFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void write(Properties prop, File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        try {
            prop.store(fos, "");
        }
        finally {
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

