/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.update;

import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class PathCalculator {
    public static void main(String[] args) throws IOException, ClassNotFoundException, SQLException {
        Properties config = new Properties();
        config.load(new FileReader(args[0]));
        Class.forName(config.getProperty("jdbc.driver"));
        long count = 0L;
        Connection con = DriverManager.getConnection(config.getProperty("jdbc.url"), config.getProperty("jdbc.username"), config.getProperty("jdbc.password"));
        PreparedStatement update = con.prepareStatement("update ld_folder set ld_path=? where ld_id=?");
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("select ld_id, ld_name, ld_parentid, ld_path from ld_folder where ld_deleted=0 and ld_path is null");
        while (rs.next()) {
            long folderId = rs.getLong(1);
            String name = rs.getString(2);
            long parentId = rs.getLong(3);
            String computedPath = PathCalculator.computePath(folderId, parentId, name, con);
            update.setString(1, computedPath);
            update.setLong(2, folderId);
            count += (long)update.executeUpdate();
        }
        update.close();
        stmt.close();
        con.close();
        System.out.println("Calculated " + count + " paths");
    }

    private static String computePath(long folderId, long parentId, String name, Connection con) throws SQLException {
        String path;
        PreparedStatement query = con.prepareStatement("select ld_id, ld_name, ld_parentid from ld_folder where ld_deleted=0 and ld_id = ?");
        String string = path = !"/".equals(name) ? Long.toString(folderId) : "/";
        while (folderId != parentId && !name.equals("/")) {
            query.setLong(1, parentId);
            ResultSet rs = query.executeQuery();
            if (rs.next()) {
                folderId = rs.getLong(1);
                name = rs.getString(2);
                parentId = rs.getLong(3);
                path = (!name.equals("/") ? Long.valueOf(folderId) : "") + "/" + path;
            }
            rs.close();
        }
        query.close();
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }
}

