/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.update;

import com.logicaldoc.installer.update.UpdateWatchDog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Date;

public class Log {
    private static PrintWriter fw = null;

    public static void info(String message, Throwable t) {
        if (fw == null) {
            return;
        }
        try {
            fw.println(String.format("%tc - INFO - %s", new Date(), message != null ? message : ""));
            if (t != null && t.getMessage() != null) {
                fw.println(t.getMessage());
            }
        }
        catch (Exception e) {
            Log.error(e.getMessage(), null);
        }
        finally {
            try {
                fw.flush();
            }
            catch (Exception exception) {}
        }
    }

    public static void error(String message, Throwable t) {
        if (fw == null) {
            return;
        }
        try {
            fw.println(String.format("%tc - ERROR - %s", new Date(), message != null ? message : ""));
            if (t != null && t.getMessage() != null) {
                fw.println(t.getMessage());
            }
        }
        catch (Exception e) {
            fw.println(String.format("%tc - ERROR - %s", new Date(), e.getMessage()));
        }
        finally {
            try {
                fw.flush();
            }
            catch (Exception exception) {}
        }
    }

    public void dispose() throws Throwable {
        fw.close();
    }

    static {
        try {
            File logFile = new File(UpdateWatchDog.getWatchDogDir() + "/logs/watchdog.log");
            logFile.getParentFile().mkdirs();
            fw = new PrintWriter(new BufferedWriter(new FileWriter(logFile, true)));
        }
        catch (Exception e) {
            e.printStackTrace();
            fw = null;
        }
    }
}

