/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.logicaldoc;

import com.izforge.izpack.api.event.ProgressListener;
import com.izforge.izpack.api.event.UninstallerListener;
import com.izforge.izpack.uninstaller.gui.UninstallerFrame;
import com.logicaldoc.installer.update.WindowsReqistry;
import com.logicaldoc.installer.util.Exec;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.Log;
import com.logicaldoc.installer.util.WinKill;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class Uninstall
implements UninstallerListener {
    private static boolean managerStopped = false;
    private static boolean tomcatServiceDeleted = false;
    private static boolean updateServiceDeleted = false;
    private static boolean databaseUninstalled = false;
    private static boolean registryCleanedup = false;

    @Override
    public void afterDelete(File arg0) {
    }

    @Override
    public void afterDelete(List<File> arg0, ProgressListener arg1) {
        this.cleanup();
    }

    @Override
    public void beforeDelete(List<File> arg0) {
        this.cleanup();
    }

    private void cleanup() {
        this.stopManager();
        this.deleteTomcatService();
        this.deleteUpdateService();
        this.uninstallDatabase();
        this.cleanRegistry();
    }

    @Override
    public void beforeDelete(List<File> arg0, ProgressListener arg1) {
        this.cleanup();
    }

    @Override
    public void beforeDelete(File file) {
        this.cleanup();
    }

    @Override
    public void initialise() {
    }

    @Override
    public boolean isFileListener() {
        return true;
    }

    private void deleteUpdateService() {
        if (!FileUtil.isWindows() || updateServiceDeleted) {
            return;
        }
        String baseName = this.getApplicationServiceName();
        try {
            Exec.exec("sc stop " + baseName + "-Update", null, null, 120);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Exec.exec("sc stop " + baseName + "-Update", null, null, 120);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Exec.exec("sc delete " + baseName + "-Update", null, null, 120);
            updateServiceDeleted = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void stopManager() {
        if (!FileUtil.isWindows() || managerStopped) {
            return;
        }
        try {
            Exec.exec("taskkill /IM LogicalDOCw.exe /F", null, null, 120);
            managerStopped = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void deleteTomcatService() {
        if (!FileUtil.isWindows() || tomcatServiceDeleted) {
            return;
        }
        String baseName = this.getApplicationServiceName();
        try {
            Exec.exec("sc stop " + baseName, null, null, 120);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Exec.exec("sc stop " + baseName, null, null, 120);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (FileUtil.isWindows()) {
            WinKill.killTomcatProcess();
        }
        try {
            Exec.exec("sc delete " + baseName, null, null, 120);
            tomcatServiceDeleted = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getInstallPath() throws Exception {
        InputStream in = UninstallerFrame.class.getResourceAsStream("/install.log");
        InputStreamReader inReader = new InputStreamReader(in);
        BufferedReader reader = new BufferedReader(inReader);
        String installPath = reader.readLine();
        reader.close();
        Log.info("install path: " + installPath, null);
        return installPath;
    }

    private String getDatabaseServiceName() {
        String serviceName = null;
        try {
            File build = new File(this.getInstallPath() + "/conf/build.properties");
            if (build.exists()) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(build));
                serviceName = prop.getProperty("db.service");
                if (serviceName != null) {
                    serviceName = serviceName.trim();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serviceName;
    }

    private String getApplicationServiceName() {
        String serviceName = "LogicalDOC";
        try {
            File build = new File(this.getInstallPath() + "/conf/build.properties");
            if (build.exists()) {
                Properties prop = new Properties();
                prop.load(new FileInputStream(build));
                serviceName = prop.getProperty("tomcat.service").trim();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serviceName;
    }

    private void uninstallDatabase() {
        if (!FileUtil.isWindows() || databaseUninstalled) {
            return;
        }
        String databaseService = this.getDatabaseServiceName();
        if (databaseService != null && !databaseService.isEmpty()) {
            try {
                Exec.exec("sc stop " + databaseService, null, null, 120);
            }
            catch (Exception exception) {}
        } else {
            databaseUninstalled = true;
            return;
        }
        try {
            File installer = new File(this.getInstallPath() + "/mariadb/mariadb.msi");
            if (installer.exists()) {
                ArrayList<String> command = new ArrayList<String>();
                command.add("msiexec");
                command.add("/i");
                command.add(installer.getPath());
                command.add("REMOVE=ALL");
                command.add("/qn");
                Exec.exec(command);
                Log.info("MariaDB has been uninstalled", null);
            }
            databaseUninstalled = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanRegistry() {
        if (registryCleanedup) {
            return;
        }
        WindowsReqistry.removeKey("\\HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\LogicalDOC");
        WindowsReqistry.removeKey("HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Apache Software Foundation\\Procrun 2.0\\LogicalDOC");
        WindowsReqistry.removeKey("HKEY_LOCAL_MACHINE\\SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall\\LogicalDOC");
        WindowsReqistry.removeKey("HKEY_LOCAL_MACHINE\\SYSTEM\\Setup\\FirstBoot\\Services\\LogicalDOC");
        registryCleanedup = true;
    }
}

