/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.logicaldoc;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.logicaldoc.installer.util.Exec;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.Log;
import com.logicaldoc.installer.util.PortUtil;
import com.logicaldoc.installer.util.ServiceUtil;
import java.io.File;
import java.util.ArrayList;

public class InstallMariaDB {
    public static String serviceName = "";
    public static int servicePort = 3350;

    public static void main(String[] args) {
        new InstallMariaDB().run(null, new String[]{"src/dist"});
    }

    public void run(AbstractUIProcessHandler handler, String[] args) {
        String installDir = args[0].trim();
        File embeddedMariaDB = new File(installDir, "mariadb");
        if (!FileUtil.isWindows() || !embeddedMariaDB.exists()) {
            Log.info("MariaDB will not be installed", null);
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("msiexec");
        command.add("/i");
        command.add(installDir + "\\mariadb\\mariadb.msi");
        command.add("/qn");
        command.add("/norestart");
        command.add("ALLUSERS=1");
        serviceName = ServiceUtil.findSuitableName("MariaDB");
        command.add("SERVICENAME=" + serviceName);
        servicePort = PortUtil.findSuitablePort(servicePort);
        command.add("PORT=" + servicePort);
        command.add("PASSWORD=logicaldoc");
        command.add("UTF8=utf8");
        command.add("/L");
        command.add(installDir + "\\mariadb\\mariadb.log");
        try {
            Log.info("Executing command: " + command, null);
            Exec.exec(command);
            Log.info("MariaDB has been installed", null);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), e);
        }
    }
}

