/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.logicaldoc;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.logicaldoc.installer.update.WindowsReqistry;
import com.logicaldoc.installer.util.Exec;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.Log;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class InstallLibreOffice {
    public void run(AbstractUIProcessHandler handler, String[] args) {
        String installDir = args[0].trim();
        String inputedLibreOffice = args[1].trim();
        File inputedLibreOfficeDir = new File(inputedLibreOffice);
        File embeddedLibreOfficeOffice = new File(installDir, "libreoffice");
        if (!(FileUtil.isWindows() && embeddedLibreOfficeOffice.exists() && inputedLibreOfficeDir.getPath().equals(embeddedLibreOfficeOffice.getPath()))) {
            System.out.println("Libre Office will not be installed");
            Log.info("Libre Office will not be installed", null);
            return;
        }
        ArrayList<String> command = new ArrayList<String>();
        command.add("msiexec");
        command.add("/i");
        command.add(installDir + "\\libreoffice\\libreoffice.msi");
        command.add("/qn");
        command.add("/norestart");
        command.add("ALLUSERS=1");
        command.add("CREATEDESKTOPLINK=0");
        command.add("REGISTER_ALL_MSO_TYPES=0");
        command.add("REGISTER_NO_MSO_TYPES=1");
        command.add("ISCHECKFORPRODUCTUPDATES=0");
        command.add("QUICKSTART=0");
        command.add("ADDLOCAL=ALL");
        command.add("UI_LANGS=en_US");
        command.add("/L");
        command.add(installDir + "\\libreoffice\\libreoffice.log");
        try {
            Log.info("Executing command: " + command, null);
            Exec.exec(command);
            Log.info("LibreOffice has been installed", null);
        }
        catch (Exception e) {
            Log.error(e.getMessage(), e);
        }
    }

    private static String installedOpenOfficePath() {
        String path = WindowsReqistry.read("HKEY_CLASSES_ROOT\\Software\\LibreOffice\\LibreOffice", "Path");
        if (path == null || path.isEmpty()) {
            path = WindowsReqistry.read("HKEY_CLASSES_ROOT\\Software\\OpenOffice\\OpenOffice", "Path");
        }
        return path;
    }

    public static String libreOfficePathProposal(String installRoot) {
        if (FileUtil.isWindows()) {
            File localLibreOffice = new File(installRoot, "libreoffice");
            String path = "";
            path = localLibreOffice.exists() && localLibreOffice.isDirectory() ? localLibreOffice.getAbsolutePath() : InstallLibreOffice.installedOpenOfficePath();
            return path.endsWith("\\") ? path.substring(0, path.length() - 1) : path;
        }
        return InstallLibreOffice.libreOfficePath(installRoot);
    }

    public static String libreOfficePath(String installRoot) {
        try {
            if (FileUtil.isWindows()) {
                String path = InstallLibreOffice.installedOpenOfficePath();
                return path.endsWith("\\") ? path.substring(0, path.length() - 1) : path;
            }
            FilenameFilter libreOfficeFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("libreoffice") && new File(dir, name).isDirectory();
                }
            };
            FilenameFilter openOfficeFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.startsWith("openoffice") && new File(dir, name).isDirectory();
                }
            };
            Comparator<File> dateComparator = new Comparator<File>(){

                @Override
                public int compare(File f1, File f2) {
                    return -Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
                }
            };
            File path = new File("/usr/lib");
            File[] children = path.listFiles(libreOfficeFilter);
            if (children != null && children.length > 0) {
                Arrays.sort(children, dateComparator);
                return children[0].getPath();
            }
            path = new File("/usr/lib64");
            children = path.listFiles(libreOfficeFilter);
            if (children != null && children.length > 0) {
                Arrays.sort(children, dateComparator);
                return children[0].getPath();
            }
            path = new File("/opt");
            children = path.listFiles(libreOfficeFilter);
            if (children != null && children.length > 0) {
                Arrays.sort(children, dateComparator);
                return children[0].getPath();
            }
            path = new File("/usr/lib");
            children = path.listFiles(openOfficeFilter);
            if (children != null && children.length > 0) {
                Arrays.sort(children, dateComparator);
                return children[0].getPath();
            }
            path = new File("/usr/lib64");
            children = path.listFiles(openOfficeFilter);
            if (children != null && children.length > 0) {
                Arrays.sort(children, dateComparator);
                return children[0].getPath();
            }
            path = new File("/opt");
            children = path.listFiles(openOfficeFilter);
            if (children != null && children.length > 0) {
                Arrays.sort(children, dateComparator);
                return children[0].getPath();
            }
            return "/opt/libreoffice";
        }
        catch (Exception t) {
            return "";
        }
    }
}

