/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.logicaldoc;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.logicaldoc.i18n.I18N;
import com.logicaldoc.installer.util.Log;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class DatabaseValidator
implements DataValidator {
    public static Map<String, String[]> dbDefaults = new HashMap<String, String[]>();

    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return I18N.message("databasenotconnected");
    }

    @Override
    public String getWarningMessageId() {
        return I18N.message("databasenotconnected");
    }

    @Override
    public DataValidator.Status validateData(InstallData data) {
        Log.info("validate DB", null);
        String engine = data.getVariable("dbengine").trim();
        String driver = dbDefaults.get(engine)[1];
        String dialect = dbDefaults.get(engine)[2];
        String validationQuery = dbDefaults.get(engine)[3];
        boolean manualUrl = "true".equals(data.getVariable("dbmanualurl").trim());
        String url = data.getVariable("dburl");
        data.setVariable("dbdriver", driver);
        data.setVariable("dbdialect", dialect);
        data.setVariable("dbquery", validationQuery);
        boolean connected = true;
        Log.info("validateData manualUrl: " + manualUrl, null);
        if ("embedded".equals(engine)) {
            url = "embedded";
            connected = true;
        } else {
            data.setVariable("dburlsuggestion", this.composeUrl(true, data));
            if (!manualUrl) {
                url = this.composeUrl(true, data);
                data.setVariable("dburl", url);
            }
            connected = this.checkDbConnection(data);
        }
        if (connected) {
            return DataValidator.Status.OK;
        }
        return DataValidator.Status.ERROR;
    }

    private String composeUrl(boolean withDb, InstallData data) {
        String engine = data.getVariable("dbengine");
        String host = data.getVariable("dbhost");
        String port = data.getVariable("dbport");
        String database = data.getVariable("dbdatabase");
        String instance = data.getVariable("dbinstance");
        String url = "jdbc:";
        if (engine.equals("mysql")) {
            url = url + "mysql://" + host.trim() + ":" + port.trim() + (withDb ? "/" + database.trim() : "") + "?useSSL=false&serverTimezone=UTC";
        } else if (engine.equals("mariadb")) {
            url = url + "mariadb://" + host.trim() + ":" + port.trim() + (withDb ? "/" + database.trim() : "");
        } else if (engine.equals("postgres")) {
            url = url + "postgresql://" + host.trim() + ":" + port.trim() + (withDb ? "/" + database.trim() : "");
        } else if (engine.equals("oracle")) {
            url = url + "oracle:thin:@" + host.trim() + ":" + port.trim() + (withDb ? ":" + database.trim() : "");
        } else if (engine.equals("mssql")) {
            url = url + "sqlserver://" + host.trim() + ":" + port.trim() + (withDb ? ";databaseName=" + database.trim() : "") + (instance != null && !instance.isEmpty() ? ";instanceName=" + instance.trim() : "") + ";encrypt=false";
        }
        Log.info("Composed DB URL: " + url, null);
        return url;
    }

    private boolean checkDbConnection(InstallData data) {
        boolean manualUrl = "true".equals(data.getVariable("dbmanualurl").trim());
        String username = data.getVariable("dbusername").trim();
        String password = data.getVariable("dbpassword").trim();
        String driver = data.getVariable("dbdriver");
        String validationQuery = data.getVariable("dbquery");
        String database = data.getVariable("dbdatabase").trim();
        String url = data.getVariable("dburl");
        Log.info("checkDbConnection manualUrl: " + manualUrl, null);
        Log.info("checkDbConnection url: " + url, null);
        if (manualUrl) {
            if (url == null || url.isEmpty()) {
                return true;
            }
            boolean connected = DatabaseValidator.checkDbConnection(url, username, password, driver, validationQuery);
            if (!connected) {
                url = url.replace(database, "");
            }
        } else {
            url = this.composeUrl(true, data);
            boolean connected = DatabaseValidator.checkDbConnection(url, username, password, driver, validationQuery);
            if (!connected) {
                url = this.composeUrl(false, data);
            }
        }
        return DatabaseValidator.checkDbConnection(url, username, password, driver, validationQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkDbConnection(String url, String username, String password, String driver, String validationQuery) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            Log.info("Validating connection to " + url, null);
            Driver d = (Driver)Class.forName(driver).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            conn = DriverManager.getConnection(url, username, password);
            stmt = conn.createStatement();
            stmt.execute(validationQuery);
            rs = stmt.getResultSet();
            if (!rs.next()) {
                throw new Exception("Unable to execute the validation query " + validationQuery);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.info("Database not connected perhaps the schema doesnt exist yet", null);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                rs.close();
            }
            catch (Throwable throwable) {}
            try {
                stmt.close();
            }
            catch (Throwable throwable) {}
            try {
                conn.close();
            }
            catch (Throwable throwable) {}
        }
    }

    public static Map<String, String[]> getDbDefaults() {
        return dbDefaults;
    }

    static {
        dbDefaults.put("embedded", new String[]{"hsqldb", "org.hsqldb.jdbc.JDBCDriver", "org.hibernate.dialect.HSQLDialect", "SELECT 1 FROM INFORMATION_SCHEMA.SYSTEM_USERS", "", ""});
        dbDefaults.put("mysql", new String[]{"mysql", "com.mysql.cj.jdbc.Driver", "org.hibernate.dialect.MySQL8Dialect", "SELECT 1", "3306", "jdbc:mysql://<server>[<:3306>]/<database>?useSSL=false&allowPublicKeyRetrieval=true&serverTimezone=UTC"});
        dbDefaults.put("mariadb", new String[]{"mariadb", "org.mariadb.jdbc.Driver", "org.hibernate.dialect.MariaDB106Dialect", "SELECT 1", "3306", "jdbc:mariadb://<server>[<:3306>]/<database>"});
        dbDefaults.put("postgres", new String[]{"postgres", "org.postgresql.Driver", "org.hibernate.dialect.PostgreSQLDialect", "SELECT 1", "5432", "jdbc:postgresql:[<//server>[<:5432>/]]<database>"});
        dbDefaults.put("oracle", new String[]{"oracle", "oracle.jdbc.driver.OracleDriver", "org.hibernate.dialect.Oracle10gDialect", "SELECT 1 FROM DUAL", "1521", "jdbc:oracle:thin:@<server>[<:1521>]:<sid>", "org.hibernate.dialect.Oracle10gDialect"});
        dbDefaults.put("mssql", new String[]{"mssql", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "org.hibernate.dialect.SQLServer2008Dialect", "SELECT 1", "1433", "jdbc:sqlserver://<server>[:<1433>];encrypt=false;trustServerCertificate=true;databaseName=<database>;instanceName=<instance>"});
    }
}

