/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.kofax;

import com.logicaldoc.installer.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ksoap2.serialization.PropertyInfo;
import org.ksoap2.serialization.SoapObject;
import org.ksoap2.serialization.SoapSerializationEnvelope;
import org.ksoap2.transport.HttpTransportSE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebserviceClient {
    private static final String WS_NAMESPACE = "http://ws.logicaldoc.com";
    private static final int SOAP_VERSION = 110;
    private static int TIMEOUT = 60000;
    public static final String FEATURE_77 = "Feature_77";
    protected static Logger log = LoggerFactory.getLogger(WebserviceClient.class);

    public static boolean validateLicense(String url) {
        if (!WebserviceClient.listFeatures(url).contains(FEATURE_77)) {
            log.info("Feature not enabled in LogicalDOC");
        }
        return WebserviceClient.listFeatures(url).contains(FEATURE_77);
    }

    public static List<String> listFeatures(String url) {
        ArrayList<String> features = new ArrayList<String>();
        Log.info("Try to contact LogicalDOC: " + url, null);
        try {
            SoapObject request = new SoapObject(WS_NAMESPACE, "getInfo");
            String invocationUrl = url + (url.endsWith("/") ? "" : "/") + "services/System";
            System.out.println("Invoking " + invocationUrl);
            SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(110);
            envelope.setOutputSoapObject(request);
            HttpTransportSE transport = new HttpTransportSE(invocationUrl, TIMEOUT);
            transport.call("", envelope);
            SoapObject response = (SoapObject)envelope.getResponse();
            PropertyInfo pinfo = new PropertyInfo();
            for (int i = 0; i < response.getPropertyCount(); ++i) {
                response.getPropertyInfo(i, pinfo);
                if (!pinfo.getName().equals("features")) continue;
                features.add(response.getProperty(i).toString());
            }
        }
        catch (Throwable t) {
            Log.error(t.getMessage(), t);
        }
        return features;
    }

    public static String login(String url, String apiKey) {
        String sid = null;
        try {
            SoapObject request = new SoapObject(WS_NAMESPACE, "loginApiKey");
            request.addProperty("apiKey", apiKey);
            String invocationUrl = url + (url.endsWith("/") ? "" : "/") + "services/Auth";
            System.out.println("Invoking " + invocationUrl);
            SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(110);
            envelope.setOutputSoapObject(request);
            HttpTransportSE transport = new HttpTransportSE(invocationUrl, TIMEOUT);
            transport.call("", envelope);
            sid = envelope.getResponse().toString();
        }
        catch (Throwable t) {
            Log.error(t.getMessage(), t);
        }
        return sid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean testCredentials(String url, String apiKey) {
        String sid = null;
        try {
            sid = WebserviceClient.login(url, apiKey);
            if (sid == null || "".equals(sid)) {
                throw new IOException("Invalid credentials");
            }
            Log.info("Server connected", null);
            boolean bl = true;
            return bl;
        }
        catch (Throwable t) {
            Log.error(t.getMessage(), t);
            boolean bl = false;
            return bl;
        }
        finally {
            WebserviceClient.logout(url, sid);
        }
    }

    public static void logout(String url, String sid) {
        if (sid == null) {
            return;
        }
        try {
            SoapObject request = new SoapObject(WS_NAMESPACE, "logout");
            request.addProperty("sid", sid);
            String invocationUrl = url + (url.endsWith("/") ? "" : "/") + "services/Auth";
            System.out.println("Invoking " + invocationUrl);
            SoapSerializationEnvelope envelope = new SoapSerializationEnvelope(110);
            envelope.setOutputSoapObject(request);
            HttpTransportSE transport = new HttpTransportSE(invocationUrl, TIMEOUT);
            transport.call("", envelope);
        }
        catch (Throwable t) {
            Log.error(t.getMessage(), t);
        }
    }
}

