/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.hotfolder;

import com.izforge.izpack.api.data.InstallData;
import com.izforge.izpack.api.installer.DataValidator;
import com.logicaldoc.installer.export.WSFolder;
import com.logicaldoc.installer.export.WebserviceClient;
import com.logicaldoc.installer.util.Log;

public class ParametersValidator
implements DataValidator {
    @Override
    public boolean getDefaultAnswer() {
        return false;
    }

    @Override
    public String getErrorMessageId() {
        return "Invalid remote folder";
    }

    @Override
    public String getWarningMessageId() {
        return "Invalid remote folder";
    }

    @Override
    public DataValidator.Status validateData(InstallData data) {
        boolean valid = false;
        String url = data.getVariable("url");
        String apiKey = data.getVariable("apikey");
        String remoteFolderPath = data.getVariable("remotefolder");
        Log.info("Validate remote folder: " + remoteFolderPath + " on server " + url, null);
        try {
            WSFolder folder = WebserviceClient.getFolder(url, apiKey, remoteFolderPath);
            valid = folder != null;
            Log.info("Retrieved folder " + folder, null);
        }
        catch (Throwable t) {
            Log.info(t.getMessage(), t);
        }
        if (valid) {
            return DataValidator.Status.OK;
        }
        return DataValidator.Status.ERROR;
    }
}

