/*
 * Decompiled with CFR 0.152.
 */
package com.logicaldoc.installer.hotfolder;

import com.izforge.izpack.panels.process.AbstractUIProcessHandler;
import com.logicaldoc.installer.export.WSFolder;
import com.logicaldoc.installer.export.WebserviceClient;
import com.logicaldoc.installer.util.FileUtil;
import com.logicaldoc.installer.util.Log;
import com.logicaldoc.installer.util.Replace;
import com.logicaldoc.util.config.ContextProperties;
import java.io.File;

public class ApplyConfiguration {
    public void run(AbstractUIProcessHandler handler, String[] args) {
        try {
            String rootDir = args[0].trim();
            String url = args[1].trim();
            String apiKey = args[2].trim();
            String localFolderPath = args[3].trim();
            String remoteFolderPath = args[4].trim();
            File contextFile = new File(args[0] + "/conf/context.properties");
            Log.info("Save configuration into " + contextFile.getAbsolutePath(), null);
            ContextProperties prop = new ContextProperties(contextFile);
            prop.setProperty("url", url);
            prop.setProperty("apikey", apiKey);
            prop.setProperty("folder.0.path", localFolderPath);
            prop.setProperty("cache.path", rootDir.replaceAll("\\\\", "/") + "/cache");
            prop.setProperty("conf.logdir", rootDir.replaceAll("\\\\", "/") + "/logs");
            prop.write();
            handler.logOutput("Saved configurations file", false);
            Log.info("Retrieve the ID of folder " + remoteFolderPath, null);
            WSFolder folder = WebserviceClient.getFolder(url, apiKey, remoteFolderPath);
            long id = 0L;
            if (folder != null) {
                id = folder.getId();
            }
            Log.info("Retrieved the ID " + id, null);
            prop.setProperty("folder.0.target", Long.toString(id));
            prop.setProperty("folder.0.target.name", remoteFolderPath);
            prop.write();
            handler.logOutput("Update target folder ID", false);
            File file = new File(rootDir + "/conf/log.xml");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/service.bat");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/manager.bat");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/hotfolder.bat");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/config.bat");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/config.sh");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/hotfolder.sh");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            file = new File(rootDir + "/bin/hotfolder");
            Replace.replace(file.getAbsolutePath(), "INSTALL_PATH", rootDir.replaceAll("\\\\", "/"));
            handler.logOutput("Updated logs path", false);
            if (!FileUtil.isWindows()) {
                File[] files;
                for (File f : files = new File(args[0] + "/bin").listFiles()) {
                    if (!f.getName().contains("hotfolder") && !f.getName().endsWith(".sh")) continue;
                    handler.logOutput("Make executable " + f.getName(), false);
                    Log.info("Make executable " + f.getName(), null);
                    f.setExecutable(true);
                    Runtime.getRuntime().exec("chmod 777 " + f.getAbsolutePath());
                }
            }
        }
        catch (Throwable e) {
            Log.error(e.getMessage(), e);
        }
    }
}

